/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.propertyeditors.ClassEditor;

public abstract class DependencyInjectionAspectSupport
implements InitializingBean,
BeanFactoryAware {
    protected final Logger log = Logger.getLogger(this.getClass());
    private BeanFactory beanFactory;
    private AutowireCapableBeanFactory aabf;
    private Map managedClassToPrototypeMap = new HashMap();
    private int defaultAutowireMode = 0;
    protected List autowireByTypeClasses = new LinkedList();
    private List autowireByNameClasses = new LinkedList();

    public int getDefaultAutowireMode() {
        return this.defaultAutowireMode;
    }

    public void setDefaultAutowireMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("defaultAutowireMode must be a constant on AutowireCapableBeanFactory: AUTOWIRE_BY_TYPE or AUTOWIRE_BY_NAME");
        }
        this.defaultAutowireMode = mode;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            this.aabf = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setAutowireByTypeClasses(List autowireByTypeClasses) {
        this.autowireByTypeClasses = this.convertListFromStringsToClassesIfNecessary(autowireByTypeClasses);
    }

    public List getAutowireByTypeClasses() {
        return this.autowireByTypeClasses;
    }

    public void addAutowireByTypeClass(Class clazz) {
        this.autowireByTypeClasses.add(clazz);
    }

    public void setAutowireByNameClasses(List autowireByNameClasses) {
        this.autowireByNameClasses = this.convertListFromStringsToClassesIfNecessary(autowireByNameClasses);
    }

    public List getAutowireByNameClasses() {
        return this.autowireByNameClasses;
    }

    public void addAutowireByNameClass(Class clazz) {
        this.autowireByNameClasses.add(clazz);
    }

    public void setManagedClassNamesToPrototypeNames(Properties persistentClassBeanNames) {
        for (String string : persistentClassBeanNames.keySet()) {
            String beanName = persistentClassBeanNames.getProperty(string);
            this.addManagedClassToPrototypeMapping(this.classNameStringToClass(string), beanName);
        }
    }

    private List convertListFromStringsToClassesIfNecessary(List l) {
        ArrayList classes = new ArrayList(l.size());
        for (Object next : l) {
            if (next instanceof String) {
                next = this.classNameStringToClass((String)next);
            }
            classes.add(next);
        }
        return classes;
    }

    private Class classNameStringToClass(String className) {
        ClassEditor ce = new ClassEditor();
        ce.setAsText(className);
        return (Class)ce.getValue();
    }

    public Map getManagedClassToPrototypeNames() {
        return this.managedClassToPrototypeMap;
    }

    public void addManagedClassToPrototypeMapping(Class clazz, String beanName) {
        this.managedClassToPrototypeMap.put(clazz, beanName);
    }

    public final void afterPropertiesSet() {
        if (this.beanFactory == null) {
            throw new IllegalArgumentException("beanFactory is required");
        }
        this.validateConfiguration();
        this.validateProperties();
    }

    protected abstract void validateProperties();

    protected void validateConfiguration() {
        if (this.managedClassToPrototypeMap.isEmpty() && this.autowireByTypeClasses.isEmpty() && this.autowireByNameClasses.isEmpty() && this.defaultAutowireMode == 0) {
            throw new IllegalArgumentException("Must set persistent class information: no managed classes configured and no autowiring configuration or defaults");
        }
        if (!(this.defaultAutowireMode == 0 && this.autowireByTypeClasses.isEmpty() && this.autowireByNameClasses.isEmpty() || this.aabf != null)) {
            throw new IllegalArgumentException("Autowiring supported only when running in an AutowireCapableBeanFactory");
        }
        for (Object o : this.managedClassToPrototypeMap.keySet()) {
            String beanName = (String)this.managedClassToPrototypeMap.get(o);
            if (!this.beanFactory.containsBean(beanName)) {
                throw new IllegalArgumentException("No bean with name '" + beanName + "' defined in factory");
            }
            if (!this.beanFactory.isSingleton(beanName)) continue;
            throw new IllegalArgumentException("Bean name '" + beanName + "' must be a prototype, with singleton=\"false\"");
        }
        this.log.info((Object)("Validated " + this.managedClassToPrototypeMap.size() + " persistent class to prototype mappings"));
    }

    protected void autowireProperties(Object o) throws NoAutowiringConfigurationForClassException, BeansException {
        if (this.autowireByTypeClasses.contains(o.getClass())) {
            this.aabf.autowireBeanProperties(o, 2, false);
        } else if (this.autowireByNameClasses.contains(o.getClass())) {
            this.aabf.autowireBeanProperties(o, 1, false);
        } else if (this.defaultAutowireMode == 2) {
            this.aabf.autowireBeanProperties(o, 2, false);
        } else if (this.defaultAutowireMode == 1) {
            this.aabf.autowireBeanProperties(o, 1, false);
        } else {
            throw new NoAutowiringConfigurationForClassException(o.getClass());
        }
        this.log.debug((Object)("Autowired properties of persistent object with class=" + o.getClass().getName()));
    }

    protected Object createAndConfigure(Class clazz) throws NoAutowiringConfigurationForClassException {
        Object o;
        String name = (String)this.managedClassToPrototypeMap.get(clazz);
        if (name != null) {
            o = this.beanFactory.getBean(name);
        } else {
            o = BeanUtils.instantiateClass((Class)clazz);
            this.autowireProperties(o);
        }
        if (o == null) {
            throw new NoAutowiringConfigurationForClassException(clazz);
        }
        return o;
    }

    protected class NoAutowiringConfigurationForClassException
    extends Exception {
        public NoAutowiringConfigurationForClassException(Class clazz) {
            super(clazz + " cannot be autowired");
        }
    }
}

