/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate.support;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hibernate.CallbackException;
import org.hibernate.EntityMode;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.hibernate.support.ChainedInterceptorSupport;
import org.springframework.orm.hibernate.support.DependencyInjectionAspectSupport;

public class DependencyInjectionInterceptorFactoryBean
extends DependencyInjectionAspectSupport
implements FactoryBean {
    private SessionFactory sessionFactory;
    private String sessionFactoryName;
    private Interceptor nextInterceptor;
    public static final AtomicBoolean ENABLED = new AtomicBoolean(true);

    public void setNextInterceptor(Interceptor nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    public Interceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setSessionFactoryName(String sessionFactoryName) {
        this.sessionFactoryName = sessionFactoryName;
    }

    @Override
    protected void validateProperties() {
        if (this.sessionFactory == null && this.sessionFactoryName == null) {
            throw new IllegalArgumentException("Either sessionFactory or sessionFactoryName property must be set");
        }
    }

    public Object getObject() throws Exception {
        HashSet classes = new HashSet(this.autowireByTypeClasses);
        classes.addAll(this.getAutowireByNameClasses());
        DependencyInjectionInterceptor dii = new DependencyInjectionInterceptor(classes);
        dii.setNextInterceptor(this.nextInterceptor);
        return dii;
    }

    public Class getObjectType() {
        return Interceptor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = (SessionFactory)this.getBeanFactory().getBean(this.sessionFactoryName, SessionFactory.class);
        }
        return this.sessionFactory;
    }

    protected class DependencyInjectionInterceptor
    extends ChainedInterceptorSupport {
        private final Set<Class<?>> classes;

        public DependencyInjectionInterceptor(Set<Class<?>> classes) {
            this.classes = classes;
        }

        @Override
        public Object instantiate(String entityName, EntityMode entityMode, Serializable id) throws CallbackException {
            Class<?> clazz;
            try {
                clazz = Class.forName(entityName);
            }
            catch (ClassNotFoundException e) {
                throw new CallbackException((Exception)e);
            }
            if (ENABLED.get() && this.classes.contains(clazz)) {
                try {
                    Object newEntity = DependencyInjectionInterceptorFactoryBean.this.createAndConfigure(clazz);
                    DependencyInjectionInterceptor.setIdOnNewEntity(DependencyInjectionInterceptorFactoryBean.this.getSessionFactory(), clazz, id, newEntity);
                    return newEntity;
                }
                catch (DependencyInjectionAspectSupport.NoAutowiringConfigurationForClassException ex) {
                    return super.instantiate(entityName, entityMode, id);
                }
            }
            return super.instantiate(entityName, entityMode, id);
        }
    }
}

