/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.upgrade.UpgradeTask;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUpgradeTask
implements UpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractUpgradeTask.class);
    protected final List<String> errors = new ArrayList<String>();
    private final String buildNumber;
    private final String shortDescription;

    @VisibleForTesting
    static String extractBuildNumber(String className) {
        String upgradeTaskNumber = StringUtils.removeStart((String)className, (String)"UpgradeTask").replaceFirst("\\D.*", "");
        Integer.valueOf(upgradeTaskNumber);
        return upgradeTaskNumber;
    }

    protected AbstractUpgradeTask(@NotNull String shortDescription) {
        this.buildNumber = AbstractUpgradeTask.extractBuildNumber(this.getClass().getSimpleName());
        this.shortDescription = shortDescription;
    }

    @Deprecated
    protected AbstractUpgradeTask(@NotNull String buildNumber, @NotNull String shortDescription) {
        this.buildNumber = buildNumber;
        this.shortDescription = shortDescription;
    }

    @Override
    @NotNull
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    @NotNull
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return this.shortDescription;
    }
}

