/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.config.db.HibernateConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.Stoppable;
import org.jetbrains.annotations.NotNull;

public class BootstrapTaskConnectionProvider {
    private static final AtomicReference<ServiceRegistry> serviceRegistryRef = new AtomicReference();

    private BootstrapTaskConnectionProvider() {
    }

    private static ConnectionProvider getConnectionProvider(HibernateConfig hibernateConfig) {
        ServiceRegistry serviceRegistry = BootstrapTaskConnectionProvider.getServiceRegistry(hibernateConfig);
        return BootstrapTaskConnectionProvider.getConnectionProvider(serviceRegistry);
    }

    private static ConnectionProvider getConnectionProvider(ServiceRegistry serviceRegistry) {
        return (ConnectionProvider)serviceRegistry.getService(ConnectionProvider.class);
    }

    private static synchronized ServiceRegistry getServiceRegistry(HibernateConfig hibernateConfig) {
        ServiceRegistry serviceRegistry = serviceRegistryRef.get();
        if (serviceRegistry != null) {
            return serviceRegistry;
        }
        serviceRegistry = BootstrapTaskConnectionProvider.newServiceRegistry(hibernateConfig);
        serviceRegistryRef.set(serviceRegistry);
        return serviceRegistry;
    }

    @NotNull
    private static StandardServiceRegistry newServiceRegistry(HibernateConfig hibernateConfig) {
        HashMap<Object, Object> dbProperties = new HashMap<Object, Object>(hibernateConfig.getHibernateProperties());
        if (dbProperties.containsKey("hibernate.hikari.maximumPoolSize")) {
            dbProperties.put("hibernate.hikari.maximumPoolSize", "2");
            dbProperties.put("hibernate.hikari.minimumIdle", "2");
        }
        return new StandardServiceRegistryBuilder().applySettings(dbProperties).build();
    }

    public static synchronized void withNoConnectionAllowed(Callable<Object> runnable) throws Exception {
        BootstrapTaskConnectionProvider.stop();
        runnable.call();
    }

    public static synchronized void stop() {
        ServiceRegistry serviceRegistry = serviceRegistryRef.get();
        if (serviceRegistry == null) {
            return;
        }
        ConnectionProvider connectionProvider = BootstrapTaskConnectionProvider.getConnectionProvider(serviceRegistry);
        if (connectionProvider instanceof Stoppable) {
            ((Stoppable)connectionProvider).stop();
        }
        StandardServiceRegistryBuilder.destroy((ServiceRegistry)serviceRegistry);
        serviceRegistryRef.set(null);
    }

    public static Connection getConnection(HibernateConfig hibernateConfig) throws SQLException {
        return BootstrapTaskConnectionProvider.getConnectionProvider(hibernateConfig).getConnection();
    }
}

