/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.AbstractXmlUpgrader;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.Lazy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationUpgrader
extends AbstractXmlUpgrader {
    protected final File cfgFile;
    private final Supplier<Pair<String, Document>> userConfiguration = Lazy.supplier((Supplier)new Supplier<Pair<String, Document>>(){

        @Override
        public Pair<String, Document> get() {
            try {
                String originalFileContent = FileUtils.readFileToString((File)ConfigurationUpgrader.this.cfgFile);
                return Pair.make((Object)originalFileContent, (Object)BambooXmlUtils.newSecureSaxReader().read(ConfigurationUpgrader.this.cfgFile));
            }
            catch (IOException | DocumentException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        }
    });

    protected ConfigurationUpgrader(@NotNull BootstrapManager bootstrapManager, String fileName) {
        Preconditions.checkNotNull((Object)bootstrapManager, (Object)"Bootstrap manager is null");
        Preconditions.checkState((!bootstrapManager.isBootstrapped() ? 1 : 0) != 0, (Object)"ConfigurationUpgrader should only be used during bootstrapping");
        this.cfgFile = new File(bootstrapManager.getConfigDirectory(), fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        OutputStreamWriter writeOut = new OutputStreamWriter((OutputStream)new FileOutputStream(this.cfgFile), StandardCharsets.UTF_8);
        XMLWriter writer = new XMLWriter((Writer)writeOut, format);
        try {
            writer.write(this.getDocument());
        }
        finally {
            ConfigurationUpgrader.closeQuietly(writer);
        }
        String originalContent = (String)this.userConfiguration.get().getFirst();
        String newContent = FileUtils.readFileToString((File)this.cfgFile, (Charset)StandardCharsets.UTF_8);
        ConfigurationUpgrader.logChanges(this.getLogPrefix() + this.cfgFile.getAbsolutePath(), originalContent, newContent);
    }

    protected abstract String getLogPrefix();

    @Override
    protected Document getDocument() {
        return (Document)this.userConfiguration.get().getSecond();
    }
}

