/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.utils;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class HikariConnectionPoolConfigurationHelper {
    private static final Logger log = Logger.getLogger(HikariConnectionPoolConfigurationHelper.class);
    public static String HIKARI_CONNECTION_PROVIDER = "org.hibernate.hikaricp.internal.HikariCPConnectionProvider";

    public static final void reconfigureConnectionPoolIfRequired(@NotNull AtlassianBootstrapManager atlassianBootstrapManager) {
        if (atlassianBootstrapManager.getProperty("hibernate.connection.datasource") != null) {
            return;
        }
        if (!HIKARI_CONNECTION_PROVIDER.equals(atlassianBootstrapManager.getProperty("hibernate.connection.provider_class"))) {
            atlassianBootstrapManager.setProperty("hibernate.connection.provider_class", (Object)HIKARI_CONNECTION_PROVIDER);
            atlassianBootstrapManager.setProperty("hibernate.connection.autocommit", (Object)"false");
            atlassianBootstrapManager.setProperty("hibernate.hikari.registerMbeans", (Object)"true");
            if (atlassianBootstrapManager.getProperty("hibernate.c3p0.min_size") != null) {
                atlassianBootstrapManager.setProperty("hibernate.hikari.minimumIdle", atlassianBootstrapManager.getProperty("hibernate.c3p0.min_size"));
            }
            if (atlassianBootstrapManager.getProperty("hibernate.c3p0.max_size") != null) {
                atlassianBootstrapManager.setProperty("hibernate.hikari.maximumPoolSize", atlassianBootstrapManager.getProperty("hibernate.c3p0.max_size"));
            }
            if (atlassianBootstrapManager.getProperty("hibernate.c3p0.timeout") != null) {
                long timeout = Long.parseLong(atlassianBootstrapManager.getProperty("hibernate.c3p0.timeout").toString()) * TimeUnit.SECONDS.toMillis(1L);
                atlassianBootstrapManager.setProperty("hibernate.hikari.idleTimeout", (Object)Long.toString(timeout));
            }
        }
    }
}

