/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.utils;

import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.config.db.HibernateConfig;

public class MsSQLTrustServerCertificateUpgrader {
    public static boolean requiresUpgrade(HibernateConfig hibernateConfig) {
        String url = hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.url");
        if (url == null || url.isEmpty()) {
            return false;
        }
        if (!url.startsWith(DatabaseType.MSSQL.getProtocol())) {
            return false;
        }
        return !url.contains("trustServerCertificate");
    }

    public static String rewriteUrl(HibernateConfig hibernateConfig) {
        String url = hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.url");
        return url + ";trustServerCertificate=true";
    }
}

