/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.persistence.BambooConnectionCallback;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bamboo.upgrade.BootstrapTaskConnectionProvider;
import com.atlassian.bamboo.upgrade.tasks.BootstrapUpgradeTask;
import com.atlassian.config.db.HibernateConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBootstrapUpgradeTask
extends AbstractUpgradeTask
implements BootstrapUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractBootstrapUpgradeTask.class);
    @Inject
    protected BootstrapManager bootstrapManager;
    @Inject
    protected HibernateConfig hibernateConfig;

    protected AbstractBootstrapUpgradeTask(@NotNull String shortDescription) {
        super(shortDescription);
    }

    @Deprecated
    protected AbstractBootstrapUpgradeTask(@NotNull String buildNumber, @NotNull String shortDescription) {
        super(buildNumber, shortDescription);
    }

    protected Connection getDatabaseConnection() throws SQLException {
        try {
            return BootstrapTaskConnectionProvider.getConnection(this.hibernateConfig);
        }
        catch (SQLException e) {
            log.error((Object)"Error getting database connection", (Throwable)e);
            throw e;
        }
    }

    @Nullable
    protected Dialect getDialect() {
        try {
            return Dialect.getDialect((Properties)this.hibernateConfig.getHibernateProperties());
        }
        catch (HibernateException e) {
            log.error((Object)"Error getting Hibernate dialect", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withDatabaseConnection(BambooConnectionCallback connectionCallback) throws HibernateException, SQLException {
        Connection connection = this.getDatabaseConnection();
        if (connection == null) {
            this.errors.add("Cannot open DB connection");
            return;
        }
        try {
            connectionCallback.doInHibernateTransaction(connection);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.warn((Object)"Failed to close connection", (Throwable)e);
            }
        }
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setHibernateConfig(HibernateConfig hibernateConfig) {
        this.hibernateConfig = hibernateConfig;
    }
}

