/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.upgrade.AbstractUpgradeTask;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractRepeatableTask
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(AbstractRepeatableTask.class);
    @Autowired
    protected BandanaManager bandanaManager;

    protected abstract void doRepeatableTask() throws Exception;

    @Nullable
    protected String getRunOnlyOnceId() {
        return null;
    }

    public AbstractRepeatableTask(@NotNull String buildNumber, @NotNull String shortDescription) {
        super(buildNumber, shortDescription);
    }

    protected boolean hasBeenRun() {
        Objects.requireNonNull(this.getRunOnlyOnceId(), "Unable to tell if the task has been run or not");
        return Boolean.TRUE.equals(this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, this.getRunOnlyOnceId()));
    }

    protected boolean needsUpgrade() {
        return this.getRunOnlyOnceId() == null || !this.hasBeenRun();
    }

    @Override
    public void doUpgrade() throws Exception {
        if (this.needsUpgrade()) {
            this.doRepeatableTask();
            String runOnlyOnceId = this.getRunOnlyOnceId();
            if (runOnlyOnceId != null) {
                this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, runOnlyOnceId, (Object)true);
            }
        } else {
            log.info((Object)"Nothing to be done.");
        }
    }
}

