/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.AbstractRepeatableTask;
import com.atlassian.bamboo.upgrade.UpgradeManager;
import com.atlassian.bamboo.upgrade.UpgradeTask;
import com.atlassian.bamboo.upgrade.UpgradeTaskIdentifier;
import com.atlassian.bamboo.upgrade.UpgradeUtilityBean;
import com.atlassian.bamboo.upgrade.tasks.BootstrapUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.PriorityUpgradeTask;
import com.atlassian.bamboo.utils.BambooClosures;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.Dom4jUtils;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.security.xml.libs.SecureDom4jFactory;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upgrade.UpgradeException;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.xwork2.TextProvider;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractUpgradeManager
implements UpgradeManager {
    private static final Logger log = Logger.getLogger(AbstractUpgradeManager.class);
    static final String XML_ATTR_BUILD = "build";
    static final String XML_ATTR_CLASS = "class";
    static final String XML_ATTR_BUILD_MIN = "build-min";
    static final String XML_ATTR_BUILD_MAX = "build-max";
    protected final Comparator<String> buildNumberComparator = Comparators.getApplicationBuildNumberComparator();
    protected String oldBuildNumber;
    protected final String newBuildNumber;
    protected final String fileName;
    protected final String xPathExpression;
    protected final SortedMap<String, UpgradeTask> upgradeTasks;
    protected final ApplicationConfiguration applicationConfig;
    protected final BootstrapManager bootstrapManager;
    protected UpgradeUtilityBean upgradeUtilityBean;
    protected TextProvider textProvider;

    protected AbstractUpgradeManager(@NotNull ApplicationConfiguration applicationConfig, @NotNull String newBuildNumber, @NotNull String fileName, @NotNull String xPathExpression, @NotNull BootstrapManager bootstrapManager) {
        this.applicationConfig = applicationConfig;
        this.newBuildNumber = newBuildNumber;
        this.fileName = fileName;
        this.xPathExpression = xPathExpression;
        this.bootstrapManager = bootstrapManager;
        this.upgradeTasks = new TreeMap<String, UpgradeTask>(this.buildNumberComparator);
    }

    @Override
    public boolean needUpgrade() {
        try {
            this.bootstrapManager.getBambooSharedProperties().load();
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return !this.newBuildNumber.equals(this.getBuildNumber());
    }

    @Override
    @NotNull
    public String getBuildNumber() {
        try {
            return this.bootstrapManager.getBambooSharedProperties().getBuildNumber();
        }
        catch (ConfigurationException e) {
            log.error((Object)e, (Throwable)e);
            return "0";
        }
    }

    protected void populateRelevantUpgrades(@NotNull String buildNumberLo, @NotNull String buildNumberHi) throws UpgradeException {
        this.upgradeTasks.clear();
        for (Map.Entry<String, UpgradeTask> entry : this.createTasks(this.xPathExpression, buildNumberLo, buildNumberHi).entrySet()) {
            this.classifyUpgradeTask(entry.getKey(), entry.getValue());
        }
    }

    protected void classifyUpgradeTask(@NotNull String bambooBuildNumber, @NotNull UpgradeTask task) throws UpgradeException {
        UpgradeTask existingTask = (UpgradeTask)this.upgradeTasks.get(bambooBuildNumber);
        if (existingTask != null) {
            throw new UpgradeException(String.format("Duplicate upgrade task: number [%s], duplicate task [%s], existing task [%s]", bambooBuildNumber, task.getClass().getName(), existingTask.getClass().getName()));
        }
        this.upgradeTasks.put(bambooBuildNumber, task);
    }

    private SortedSet<UpgradeTaskIdentifier> createTaskIdentifiers(@NotNull String xPathExpression, @NotNull String installationBuildNumber, @NotNull String upgradeBuildNumber) throws UpgradeException {
        TreeSet<UpgradeTaskIdentifier> upgradeTasks = new TreeSet<UpgradeTaskIdentifier>(Comparator.comparing(UpgradeTaskIdentifier::getBuildNumber, this.buildNumberComparator));
        try {
            Document xmlDoc = this.getUpgradeDocument();
            List upgradeTaskNodes = Dom4jUtils.selectElements((Document)xmlDoc, (String)xPathExpression);
            for (Element element : upgradeTaskNodes) {
                String className;
                String buildNumber;
                if (!this.shouldRunTask(element, installationBuildNumber, upgradeBuildNumber) || upgradeTasks.add(new UpgradeTaskIdentifier(buildNumber = element.attributeValue(XML_ATTR_BUILD), className = StringUtils.defaultString((String)element.attributeValue(XML_ATTR_CLASS), (String)element.elementText(XML_ATTR_CLASS))))) continue;
                throw new UpgradeException(String.format("Duplicate upgrade task: number [%s], duplicate task [%s]", buildNumber, className));
            }
        }
        catch (DocumentException e) {
            throw new UpgradeException("Error while parsing upgrade document", e);
        }
        return upgradeTasks;
    }

    protected SortedMap<String, UpgradeTask> createTasks(@NotNull String xPathExpression, @NotNull String installationBuildNumber, @NotNull String upgradeBuildNumber) throws UpgradeException {
        TreeMap<String, UpgradeTask> upgradeTasks = new TreeMap<String, UpgradeTask>(this.buildNumberComparator);
        for (UpgradeTaskIdentifier upgradeTaskIdentifier : this.createTaskIdentifiers(xPathExpression, installationBuildNumber, upgradeBuildNumber)) {
            upgradeTasks.put(upgradeTaskIdentifier.getBuildNumber(), this.createUpgradeTask(upgradeTaskIdentifier.getClassName()));
        }
        return upgradeTasks;
    }

    protected <E extends Exception> void forEachTask(@NotNull String xPathExpression, @NotNull String installationBuildNumber, @NotNull String upgradeBuildNumber, @NotNull BambooClosures.Throwing1<UpgradeTask, E> action) throws UpgradeException, E {
        for (UpgradeTaskIdentifier upgradeTaskIdentifier : this.createTaskIdentifiers(xPathExpression, installationBuildNumber, upgradeBuildNumber)) {
            action.run((Object)this.createUpgradeTask(upgradeTaskIdentifier.getClassName()));
        }
    }

    @VisibleForTesting
    public UpgradeTask createUpgradeTask(String className) throws UpgradeException {
        try {
            return (UpgradeTask)ContainerManager.getInstance().getContainerContext().createCompleteComponent(Class.forName(className));
        }
        catch (Throwable e) {
            throw new UpgradeException(String.format("Cannot instantiate upgrade task [%s]", className), e);
        }
    }

    protected Document getUpgradeDocument() throws DocumentException {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)this.fileName, this.getClass());
        SAXReader saxReader = SecureDom4jFactory.newSaxReader();
        Document xmlDoc = saxReader.read(is);
        try {
            is.close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return xmlDoc;
    }

    protected String runUpgradeTask(@NotNull UpgradeTask task, @NotNull List<String> errors) {
        String thisTaskBuildNumber = task.getBuildNumber();
        String description = this.getDescription(task, thisTaskBuildNumber);
        log.info((Object)StringUtils.repeat((String)"-", (int)description.length()));
        log.info((Object)description);
        log.info((Object)StringUtils.repeat((String)"-", (int)description.length()));
        try {
            task.doUpgrade();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            errors.add("Task for build " + thisTaskBuildNumber + " failed with exception: " + e.getMessage());
        }
        String taskName = "Task " + thisTaskBuildNumber;
        List<String> taskErrors = task.getErrors();
        if (CollectionUtils.isEmpty(taskErrors)) {
            log.info((Object)(taskName + " completed successfully."));
        } else {
            errors.add(taskName + " failed:");
            errors.addAll(taskErrors);
            log.info((Object)(taskName + " completed with errors."));
        }
        return thisTaskBuildNumber;
    }

    @NotNull
    protected String getDescription(@NotNull UpgradeTask task, String thisTaskBuildNumber) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (task instanceof AbstractRepeatableTask) {
            modifiers.add("repeatable");
        } else if (task instanceof BootstrapUpgradeTask) {
            modifiers.add("bootstrap");
        } else {
            modifiers.add("post-bootstrap");
        }
        if (task instanceof PriorityUpgradeTask) {
            modifiers.add("priority");
        }
        String modifiersStr = String.join((CharSequence)", ", modifiers);
        return thisTaskBuildNumber + " : " + task.getShortDescription() + " (" + modifiersStr + ")";
    }

    protected boolean shouldRunTask(@NotNull Element element, @NotNull String installationBuildNumber, @NotNull String upgradeBuildNumber) {
        String buildNumber = element.attributeValue(XML_ATTR_BUILD);
        String buildNumberMin = element.attributeValue(XML_ATTR_BUILD_MIN);
        String buildNumberMax = element.attributeValue(XML_ATTR_BUILD_MAX);
        if (buildNumberMin != null && Comparators.isGreater((Object)buildNumberMin, (Object)installationBuildNumber, this.buildNumberComparator)) {
            return false;
        }
        if (buildNumberMax != null && Comparators.isLesser((Object)buildNumberMax, (Object)installationBuildNumber, this.buildNumberComparator)) {
            return false;
        }
        if (buildNumberMin == null && Comparators.isLesserOrEqual((Object)buildNumber, (Object)installationBuildNumber, this.buildNumberComparator)) {
            return false;
        }
        return buildNumberMax != null || !Comparators.isGreater((Object)buildNumber, (Object)upgradeBuildNumber, this.buildNumberComparator);
    }

    public SortedMap<String, UpgradeTask> getUpgradeTasks() {
        return this.upgradeTasks;
    }

    @Override
    public String getOldBuildNumber() {
        return this.oldBuildNumber;
    }

    public void setUpgradeUtilityBean(UpgradeUtilityBean upgradeUtilityBean) {
        this.upgradeUtilityBean = upgradeUtilityBean;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

