/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.utils.XmlDiffFinder;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlUpgrader {
    private static final Logger log = Logger.getLogger(AbstractXmlUpgrader.class);

    protected abstract Document getDocument();

    public abstract void save() throws IOException;

    public void setOrAdd(@NotNull String elementName, @NotNull String value) {
        this.setOrAdd(this.getRootElement(), elementName, value);
    }

    public void setOrAdd(@NotNull Element parent, @NotNull String elementName, @NotNull String value) {
        Element element = parent.element(elementName);
        if (element == null) {
            element = parent.addElement(elementName);
        }
        element.setText(value);
    }

    public void setOrAdd(@NotNull Element element) {
        this.setOrAdd(this.getRootElement(), element);
    }

    public void setOrAdd(@NotNull Element parent, @NotNull Element element) {
        Element existingElement = parent.element(element.getName());
        if (existingElement != null) {
            parent.remove(existingElement);
        }
        parent.add(element);
    }

    public void update(Element element) {
        Element parent = this.removeElement(element);
        parent.add(element);
    }

    public void remove(Element element) {
        this.removeElement(element);
    }

    private Element removeElement(Element element) {
        Element parent = element.getParent();
        parent.remove(element);
        return parent;
    }

    public Element getRootElement() {
        return this.getDocument().getRootElement();
    }

    @Nullable
    public Element getElement(@NotNull String xpathExpression) {
        return this.getElement(this.getRootElement(), xpathExpression);
    }

    @Nullable
    public Element getElement(@NotNull Element parent, @NotNull String xpathExpression) {
        Node node = parent.selectSingleNode(xpathExpression);
        if (node != null) {
            Preconditions.checkState((node.getNodeType() == 1 ? 1 : 0) != 0, (String)"XPath expression '%s' does not identify element", (Object)xpathExpression);
            return (Element)node;
        }
        return null;
    }

    public static Map<String, String> asMap(@NotNull Element element) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList entries = Lists.newArrayList((Iterator)element.elementIterator());
        for (Element entry : entries) {
            if (!entry.getName().equals("entry")) {
                throw new IllegalArgumentException("Unknown map content: " + entry.getName());
            }
            ArrayList keyValue = Lists.newArrayList((Iterator)entry.elementIterator());
            if (keyValue.size() != 2) {
                throw new IllegalArgumentException(keyValue.size() + " elements found in an entry: " + entry.getName());
            }
            map.put(((Element)keyValue.get(0)).getText(), ((Element)keyValue.get(1)).getText());
        }
        return map;
    }

    public static Element asElement(Map<String, String> artifactHandlerConfiguration, String name) {
        DefaultElement rootElement = new DefaultElement(name);
        for (Map.Entry<String, String> stringStringEntry : artifactHandlerConfiguration.entrySet()) {
            DefaultElement entry = new DefaultElement("entry");
            entry.add((Element)AbstractXmlUpgrader.newElement("string", stringStringEntry.getKey()));
            entry.add((Element)AbstractXmlUpgrader.newElement("string", stringStringEntry.getValue()));
            rootElement.add((Element)entry);
        }
        return rootElement;
    }

    public static void saveNode(Node node, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(node.asXML());
        }
    }

    public static void appendComment(String comment, File file) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);){
            writer.write(System.getProperty("line.separator"));
            writer.write("<!-- " + comment + " -->");
        }
    }

    @Nullable
    public String getElementText(@NotNull Element parent, @NotNull String elementName) {
        Element element = parent.element(elementName);
        return element != null ? element.getText() : null;
    }

    private static DefaultElement newElement(String name, String value) {
        DefaultElement defaultElement = new DefaultElement(name);
        defaultElement.setText(value);
        return defaultElement;
    }

    protected static void closeQuietly(XMLWriter writer) {
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected static void logChanges(String xmlSourceIdentifier, String originalContent, String newContent) {
        if (originalContent.equals(newContent)) {
            log.debug((Object)("No changes done to " + xmlSourceIdentifier));
            return;
        }
        log.info((Object)("Changes to " + xmlSourceIdentifier + ":"));
        XmlDiffFinder xmlDiffFinder = new XmlDiffFinder(originalContent, newContent);
        List changes = xmlDiffFinder.findChanges();
        for (AuditLogService.FieldChange change : changes) {
            log.info((Object)(change.getFieldName() + ": " + change.getOldValue() + " -> " + change.getNewValue()));
        }
    }
}

