/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.AbstractUpgradeManager;
import com.atlassian.bamboo.upgrade.BootstrapUpgradeManager;
import com.atlassian.bamboo.upgrade.UpgradeTask;
import com.atlassian.bamboo.upgrade.exception.ValidationException;
import com.atlassian.bamboo.upgrade.utils.impl.BootstrapUpgradeHelper;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.upgrade.UpgradeException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BootstrapUpgradeManagerImpl
extends AbstractUpgradeManager
implements BootstrapUpgradeManager,
ApplicationContextAware {
    private static final Logger log = Logger.getLogger(BootstrapUpgradeManagerImpl.class);
    @VisibleForTesting
    static final String UPGRADES_XPATH = "//upgrades/bootstrap/upgrade";
    @VisibleForTesting
    static final String VALIDATION_XPATH = "//upgrades/validation/upgrade";
    private AutowireCapableBeanFactory autowireCapableBeanFactory;
    private BootstrapUpgradeHelper bootstrapUpgradeHelper;

    public BootstrapUpgradeManagerImpl(@NotNull ApplicationConfiguration applicationConfig, @NotNull BootstrapUpgradeHelper bootstrapUpgradeHelper, BootstrapManager bootstrapManager, @NotNull String fileName) {
        super(applicationConfig, BuildUtils.getCurrentBuildNumber(), fileName, UPGRADES_XPATH, bootstrapManager);
        this.bootstrapUpgradeHelper = bootstrapUpgradeHelper;
    }

    @VisibleForTesting
    protected BootstrapUpgradeManagerImpl(@NotNull ApplicationConfiguration applicationConfig, @NotNull BootstrapUpgradeHelper bootstrapUpgradeHelper, @NotNull BootstrapManager bootstrapManager, @NotNull String newBuildNumber, @NotNull String fileName) {
        super(applicationConfig, newBuildNumber, fileName, UPGRADES_XPATH, bootstrapManager);
        this.bootstrapUpgradeHelper = bootstrapUpgradeHelper;
    }

    @Override
    public List<String> runUpgradesForHotswapImport() throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        UpgradeTask upgradeTask = this.createUpgradeTask("com.atlassian.bamboo.upgrade.tasks.v9_4.UpgradeTask90408ChangeDefaultJmsKeyStorePassword");
        this.runUpgradeTask(upgradeTask, errors);
        return errors;
    }

    @Override
    @NotNull
    public List<String> doUpgrade(boolean partOfSetup) throws Exception {
        String buildNumber;
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.needUpgrade()) {
            return errors;
        }
        this.oldBuildNumber = buildNumber = this.getBuildNumber();
        this.populateRelevantUpgrades(buildNumber, this.newBuildNumber);
        Collection bootstrapUpgradeTasks = this.upgradeTasks.values();
        log.info((Object)("Found " + bootstrapUpgradeTasks.size() + " bootstrap upgrade tasks"));
        for (UpgradeTask upgradeTask : bootstrapUpgradeTasks) {
            this.runUpgradeTask(upgradeTask, errors);
            if (errors.isEmpty()) continue;
            break;
        }
        return errors;
    }

    @Override
    @NotNull
    public List<String> runValidationTasks() throws ValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            this.forEachTask(VALIDATION_XPATH, this.getBuildNumber(), this.newBuildNumber, upgradeTask -> errors.addAll(this.runValidationTask((UpgradeTask)upgradeTask)));
        }
        catch (UpgradeException e) {
            log.fatal((Object)"Cannot create list of validation tests", (Throwable)e);
            errors.add("Cannot create list of validation tests: " + e.getMessage());
            return errors;
        }
        return errors;
    }

    @Override
    @VisibleForTesting
    public UpgradeTask createUpgradeTask(String className) throws UpgradeException {
        try {
            return (UpgradeTask)this.autowireCapableBeanFactory.createBean(Class.forName(className), 4, false);
        }
        catch (Throwable e) {
            throw new UpgradeException(String.format("Cannot instantiate upgrade task [%s]", className), e);
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.autowireCapableBeanFactory = appContext.getAutowireCapableBeanFactory();
    }

    @VisibleForTesting
    List<String> runValidationTask(@NotNull UpgradeTask task) throws ValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        String thisTaskBuildNumber = task.getBuildNumber();
        String description = this.getDescription(task, thisTaskBuildNumber);
        log.info((Object)StringUtils.repeat((String)"-", (int)description.length()));
        log.info((Object)description);
        log.info((Object)StringUtils.repeat((String)"-", (int)description.length()));
        String taskName = "Task " + thisTaskBuildNumber;
        try {
            task.doUpgrade();
            List<String> taskErrors = task.getErrors();
            if (CollectionUtils.isEmpty(taskErrors)) {
                log.info((Object)(taskName + " completed successfully."));
            } else {
                errors.add(taskName + " failed:");
                errors.addAll(taskErrors);
                log.info((Object)(taskName + " completed with errors."));
            }
        }
        catch (ValidationException e) {
            log.fatal((Object)(taskName + " failed"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)(taskName + " failed"), (Throwable)e);
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), ValidationException.class);
            errors.add(taskName + " failed with exception: " + e.getMessage());
        }
        return errors;
    }
}

