/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.upgrade.AbstractXmlUpgrader;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import io.atlassian.util.concurrent.Lazy;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.jetbrains.annotations.NotNull;

public class BuildDefinitionUpgrader
extends AbstractXmlUpgrader {
    private static final Logger log = Logger.getLogger(BuildDefinitionUpgrader.class);
    private final Plan plan;
    private final PlanManager planManager;
    private final Supplier<Pair<String, Document>> buildDefinitionDocument = Lazy.supplier((Supplier)new Supplier<Pair<String, Document>>(){

        @Override
        public Pair<String, Document> get() {
            String buildDefinitionXml = BuildDefinitionUpgrader.this.plan.getBuildDefinitionXml().getXmlData();
            try {
                return Pair.make((Object)buildDefinitionXml, (Object)BambooXmlUtils.newSecureSaxReader().read((Reader)new StringReader(buildDefinitionXml)));
            }
            catch (DocumentException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        }
    });

    public BuildDefinitionUpgrader(@NotNull PlanManager planManager, @NotNull Plan plan) throws DocumentException {
        this.planManager = planManager;
        this.plan = plan;
    }

    @Override
    protected Document getDocument() {
        return (Document)this.buildDefinitionDocument.get().getSecond();
    }

    @Override
    public void save() {
        String newXmlData = this.getDocument().asXML();
        this.plan.getBuildDefinitionXml().setXmlData(newXmlData);
        this.planManager.savePlan(this.plan);
        BuildDefinitionUpgrader.logChanges("Build configuration for: " + this.plan.getPlanKey().toString(), (String)this.buildDefinitionDocument.get().getFirst(), newXmlData);
    }
}

