/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.bandana.BandanaItemDao;
import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.setup.BambooSharedProperties;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.upgrade.AbstractUpgradeManager;
import com.atlassian.bamboo.upgrade.UpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.PriorityUpgradeTask;
import com.atlassian.bamboo.upgrade.tasks.StartupUpgradeTask;
import com.atlassian.bamboo.util.BambooHibernateUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.ConfigurationException;
import com.atlassian.upgrade.UpgradeException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.hibernate.Session;
import org.jetbrains.annotations.NotNull;

public class UpgradeManagerImpl
extends AbstractUpgradeManager {
    private static final Logger log = Logger.getLogger(UpgradeManagerImpl.class);
    @VisibleForTesting
    static final String UPGRADES_XPATH = "//upgrades/postBootstrap/upgrade";
    @VisibleForTesting
    static final String REPEATED_UPGRADES_XPATH = "//upgrades/repeatable/upgrade";
    private final BandanaItemDao bandanaItemDao;
    private final BambooTransactionHibernateTemplate transactionTemplate;
    private SortedMap<String, UpgradeTask> priorityUpgrades;

    public UpgradeManagerImpl(@NotNull ApplicationConfiguration applicationConfig, @NotNull BandanaItemDao bandanaItemDao, @NotNull BambooTransactionHibernateTemplate transactionTemplate, @NotNull BootstrapManager bootstrapManager, @NotNull String fileName) {
        super(applicationConfig, BuildUtils.getCurrentBuildNumber(), fileName, UPGRADES_XPATH, bootstrapManager);
        this.priorityUpgrades = new TreeMap<String, UpgradeTask>(this.buildNumberComparator);
        this.bandanaItemDao = bandanaItemDao;
        this.transactionTemplate = transactionTemplate;
    }

    @VisibleForTesting
    protected UpgradeManagerImpl(@NotNull ApplicationConfiguration applicationConfig, @NotNull BandanaItemDao bandanaItemDao, @NotNull BambooTransactionHibernateTemplate transactionTemplate, @NotNull BootstrapManager bootstrapManager, @NotNull String newBuildNumber, @NotNull String fileName) {
        super(applicationConfig, newBuildNumber, fileName, UPGRADES_XPATH, bootstrapManager);
        this.priorityUpgrades = new TreeMap<String, UpgradeTask>(this.buildNumberComparator);
        this.bandanaItemDao = bandanaItemDao;
        this.transactionTemplate = transactionTemplate;
    }

    private boolean hasRepeatableTasks() {
        try {
            Document xmlDoc = this.getUpgradeDocument();
            return !xmlDoc.selectNodes(REPEATED_UPGRADES_XPATH).isEmpty();
        }
        catch (DocumentException e) {
            return false;
        }
    }

    @Override
    public boolean needUpgrade() {
        return super.needUpgrade() || this.hasRepeatableTasks();
    }

    @Override
    @NotNull
    public List<String> doUpgrade(boolean partOfSetup) throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        if (super.needUpgrade()) {
            this.oldBuildNumber = this.getBuildNumber();
            this.populateRelevantUpgrades(this.getBuildNumber(), this.newBuildNumber);
            Iterable<UpgradeTask> priorityUpgradeTasks = this.priorityUpgrades.values();
            if (partOfSetup) {
                priorityUpgradeTasks = Iterables.filter(priorityUpgradeTasks, StartupUpgradeTask.class::isInstance);
            }
            log.info((Object)("Found " + Iterables.size(priorityUpgradeTasks) + " high priority upgrade tasks"));
            for (UpgradeTask upgradeTask : priorityUpgradeTasks) {
                this.runUpgradeTask(upgradeTask, errors);
                if (errors.isEmpty()) continue;
                break;
            }
            if (errors.isEmpty()) {
                Iterable<Object> nonPriorityUpgradeTasks = this.upgradeTasks.values();
                if (partOfSetup) {
                    nonPriorityUpgradeTasks = Iterables.filter(nonPriorityUpgradeTasks, StartupUpgradeTask.class::isInstance);
                }
                log.info((Object)("Found " + Iterables.size(nonPriorityUpgradeTasks) + " upgrade tasks"));
                for (UpgradeTask upgradeTask : nonPriorityUpgradeTasks) {
                    String thisTaskBuildNumber = this.runUpgradeTask(upgradeTask, errors);
                    if (!errors.isEmpty()) break;
                    this.setBuildNumber(thisTaskBuildNumber);
                }
            }
        }
        if (errors.isEmpty()) {
            this.setBuildNumber(this.newBuildNumber);
        }
        if (errors.isEmpty() && !partOfSetup) {
            errors.addAll(this.runRepeatableUpgradeTasks());
        }
        return errors;
    }

    @Override
    protected void populateRelevantUpgrades(@NotNull String buildNumberLo, @NotNull String buildNumberHi) throws UpgradeException {
        this.priorityUpgrades.clear();
        super.populateRelevantUpgrades(buildNumberLo, buildNumberHi);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void classifyUpgradeTask(@NotNull String bambooBuildNumber, @NotNull UpgradeTask task) throws UpgradeException {
        if (task instanceof PriorityUpgradeTask) {
            UpgradeTask existingTask = (UpgradeTask)this.priorityUpgrades.get(bambooBuildNumber);
            if (existingTask != null) throw new UpgradeException(String.format("Duplicate priority upgrade task: number [%s], duplicate task [%s], existing task [%s]", bambooBuildNumber, task.getClass().getName(), existingTask.getClass().getName()));
            this.priorityUpgrades.put(bambooBuildNumber, task);
            return;
        } else {
            super.classifyUpgradeTask(bambooBuildNumber, task);
        }
    }

    @NotNull
    private List<String> runRepeatableUpgradeTasks() throws Exception {
        ArrayList<String> errors = new ArrayList<String>();
        SortedMap<String, UpgradeTask> repeatableUpgradeTasks = this.createTasks(REPEATED_UPGRADES_XPATH, this.newBuildNumber, this.newBuildNumber);
        log.info((Object)("Found " + repeatableUpgradeTasks.size() + " repeated upgrade tasks"));
        for (UpgradeTask upgradeTask : repeatableUpgradeTasks.values()) {
            this.runUpgradeTask(upgradeTask, errors);
            if (errors.isEmpty()) continue;
            break;
        }
        return errors;
    }

    private void setBuildNumber(@NotNull String buildNumber) throws ConfigurationException {
        this.transactionTemplate.execute(session -> {
            this.bandanaItemDao.saveOrUpdate(this.upgradeUtilityBean.getBandanaContextForDbVersion(), this.upgradeUtilityBean.getBandanaKeyForDbVersion(), buildNumber);
            BambooHibernateUtils.flushIfNeeded((Session)session);
            return null;
        });
        this.applicationConfig.setBuildNumber(buildNumber);
        this.applicationConfig.save();
        BambooSharedProperties bambooSharedProperties = this.bootstrapManager.getBambooSharedProperties();
        bambooSharedProperties.setBuildNumber(buildNumber);
        bambooSharedProperties.save();
    }
}

