/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.xml.BambooXmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class XpathXmlUpgrader {
    private static final Logger log = Logger.getLogger(XpathXmlUpgrader.class);

    public static void visit(File file, String xPathExpression, Consumer<Node> visitor) {
        XpathXmlUpgrader.read(file).ifPresent(document -> XpathXmlUpgrader.visit(document, xPathExpression, visitor));
    }

    public static void transform(File file, String xPathExpression, Consumer<Node> transformation) {
        XpathXmlUpgrader.read(file).map(document -> XpathXmlUpgrader.visit(document, xPathExpression, transformation)).ifPresent(document -> XpathXmlUpgrader.write(document, file));
    }

    public static Document visit(Document document, String xPathExpression, Consumer<Node> visitor) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate(xPathExpression, document.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                visitor.accept(nodeList.item(i));
            }
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
        return document;
    }

    public static Optional<Document> read(File inputFile) {
        try {
            return XpathXmlUpgrader.read(Files.newInputStream(inputFile.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Optional<Document> read(InputStream input) {
        try {
            DocumentBuilder builder = BambooXmlUtils.newSecureDocumentBuilderFactory((Logger)log).newDocumentBuilder();
            return Optional.of(builder.parse(input));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void write(Document dom, File outputFile) {
        try {
            XpathXmlUpgrader.write(dom, Files.newOutputStream(outputFile.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void write(Document dom, OutputStream output) {
        try {
            DOMImplementation domImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("LS");
            DOMImplementationLS domImplLS = (DOMImplementationLS)Narrow.to((Object)domImplementation, DOMImplementationLS.class);
            if (domImplLS == null) {
                log.error((Object)"Failed to find DOMImplementationLS in the registry");
                return;
            }
            LSOutput lsOutput = domImplLS.createLSOutput();
            lsOutput.setByteStream(output);
            LSSerializer serializer = domImplLS.createLSSerializer();
            serializer.write(dom, lsOutput);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

