/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.utils;

import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.config.db.HibernateConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class JtdsUpgrader {
    public static final String JTDS_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    private static final String JTDS_PROTOCOL = "jdbc:jtds:sqlserver";
    private static final Pattern JTDS_URL = Pattern.compile("jdbc:jtds:sqlserver://([^:;/]++)(?::([\\d]{1,5}))?(?:/([^;]++))?(?:$|([^:/].*))");

    public static boolean requiresUpgrade(@NotNull HibernateConfig hibernateConfig) {
        return JTDS_DRIVER.equals(hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.driver_class"));
    }

    public static String rewriteUrl(@NotNull HibernateConfig hibernateConfig) {
        String url = hibernateConfig.getHibernateProperties().getProperty("hibernate.connection.url");
        Matcher matcher = JTDS_URL.matcher(url);
        if (matcher.matches()) {
            Map<String, String> parameters = JtdsUpgrader.parseJtdsParameters(matcher.group(4));
            String databaseName = matcher.group(3);
            if (databaseName == null) {
                databaseName = parameters.remove("databaseName");
            }
            if (databaseName != null && parameters.isEmpty()) {
                int port = JtdsUpgrader.parseJtdsPort(matcher.group(2));
                return DatabaseType.MSSQL.generateUrl(matcher.group(1), databaseName, port);
            }
        }
        throw new IllegalArgumentException(String.format("Unable to update JDBC URL %s", url));
    }

    private static Map<String, String> parseJtdsParameters(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(Arrays.stream(value.split(";")).filter(StringUtils::isNotBlank).map(piece -> piece.split("=")).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1])));
    }

    private static int parseJtdsPort(String value) {
        return value == null ? DatabaseType.MSSQL.getDefaultPort() : Integer.parseInt(value);
    }
}

