/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.utils.impl;

import com.atlassian.bamboo.upgrade.BootstrapTaskConnectionProvider;
import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.db.HibernateConfig;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.jetbrains.annotations.NotNull;

public class BootstrapUpgradeHelper {
    private static final Logger log = Logger.getLogger(BootstrapUpgradeHelper.class);
    private final ApplicationConfiguration applicationConfiguration;
    private final HibernateConfig hibernateConfig;

    @Inject
    public BootstrapUpgradeHelper(ApplicationConfiguration applicationConfiguration, HibernateConfig hibernateConfig) {
        this.applicationConfiguration = applicationConfiguration;
        this.hibernateConfig = hibernateConfig;
    }

    @NotNull
    public String getBuildNumberFromLocalHomeDirectory() {
        return StringUtils.defaultString((String)this.applicationConfiguration.getBuildNumber(), (String)"0");
    }

    public Connection getDatabaseConnection() throws HibernateException, SQLException {
        try {
            return BootstrapTaskConnectionProvider.getConnection(this.hibernateConfig);
        }
        catch (SQLException e) {
            log.error((Object)"Error getting database connection", (Throwable)e);
            throw e;
        }
    }
}

