/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.upgrade.utils.impl;

import com.atlassian.bamboo.persistence.BambooTransactionHibernateTemplate;
import com.atlassian.bamboo.upgrade.utils.DatabaseUpgradePaginator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class DatabaseUpgradePaginatorImpl
implements DatabaseUpgradePaginator {
    private static final Logger log = Logger.getLogger(DatabaseUpgradePaginatorImpl.class);
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private final BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate;

    @Autowired
    public DatabaseUpgradePaginatorImpl(BambooTransactionHibernateTemplate bambooTransactionHibernateTemplate) {
        this.bambooTransactionHibernateTemplate = bambooTransactionHibernateTemplate;
    }

    @Override
    public <T> void forEachPage(@NotNull DatabaseUpgradePaginator.PaginatedDataSupplier<T> dataSupplier, @NotNull Consumer<Collection<T>> elementConsumer) {
        this.forEachPage(dataSupplier, 1000, elementConsumer);
    }

    @Override
    public <T> void forEachPage(@NotNull DatabaseUpgradePaginator.PaginatedDataSupplier<T> dataSupplier, int pageSize, @NotNull Consumer<Collection<T>> elementConsumer) {
        DatabaseUpgradePaginator.PaginatedDataSupplier transactionWrappedDataSupplier = (offset, limit) -> (Collection)this.bambooTransactionHibernateTemplate.execute(transaction -> dataSupplier.getPage(offset, limit));
        new PageIterator(transactionWrappedDataSupplier, pageSize).forEachRemaining(page -> this.bambooTransactionHibernateTemplate.doWork(connection -> elementConsumer.accept((Collection)page)));
    }

    @Override
    public <T> void forEach(@NotNull DatabaseUpgradePaginator.PaginatedDataSupplier<T> dataSupplier, @NotNull Consumer<T> consumer) {
        this.forEach(dataSupplier, 1000, consumer);
    }

    @Override
    public <T> void forEach(@NotNull DatabaseUpgradePaginator.PaginatedDataSupplier<T> dataSupplier, int pageSize, @NotNull Consumer<T> consumer) {
        this.forEachPage(dataSupplier, pageSize, collection -> collection.forEach(consumer));
    }

    @VisibleForTesting
    static class PageIterator<T>
    implements Iterator<Collection<T>> {
        private final DatabaseUpgradePaginator.PaginatedDataSupplier<T> dataSupplier;
        private final int pageSize;
        private boolean finished;
        private int nextPageOffset;
        private Collection<T> currentPage;

        PageIterator(@NotNull DatabaseUpgradePaginator.PaginatedDataSupplier<T> dataSupplier, int pageSize) {
            this.dataSupplier = dataSupplier;
            this.pageSize = pageSize;
        }

        @Override
        public boolean hasNext() {
            if (!this.finished && this.currentPage == null) {
                int doneSoFar = this.nextPageOffset;
                this.currentPage = this.dataSupplier.getPage(this.nextPageOffset, this.pageSize);
                this.nextPageOffset += this.pageSize;
                if (this.currentPage.isEmpty()) {
                    this.finished = true;
                    this.currentPage = null;
                    log.info((Object)"Done.");
                } else if (doneSoFar > 0) {
                    log.info((Object)String.format("%s done...", doneSoFar));
                }
            }
            return !this.finished;
        }

        @Override
        public Collection<T> next() {
            if (this.hasNext()) {
                Collection<T> result = this.currentPage;
                this.currentPage = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

