/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upgrade;

import com.atlassian.upgrade.UpgradeTask;
import com.opensymphony.util.TextUtils;
import java.util.Comparator;

public class BuildNumComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        Double number1 = null;
        Double number2 = null;
        if (o1 instanceof UpgradeTask && o2 instanceof UpgradeTask) {
            number1 = this.getBuildNumber(((UpgradeTask)o1).getBuildNumber());
            number2 = this.getBuildNumber(((UpgradeTask)o2).getBuildNumber());
        } else {
            if (o1 != null) {
                number1 = this.getBuildNumber(o1);
            }
            if (o2 != null) {
                number2 = this.getBuildNumber(o2);
            }
        }
        if (number1 == null && number2 == null) {
            return 0;
        }
        if (number1 == null) {
            return 1;
        }
        if (number2 == null) {
            return -1;
        }
        return number1.compareTo(number2);
    }

    private Double getBuildNumber(Object version) {
        String buildNumber;
        String versionString = (String)version;
        StringBuilder sb = new StringBuilder(versionString.length());
        boolean decSeen = false;
        for (int i = 0; i < versionString.toCharArray().length; ++i) {
            char c = versionString.toCharArray()[i];
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            if (c != '.') break;
            if (!decSeen) {
                decSeen = true;
                sb.append('.');
                continue;
            }
            sb.append('0');
        }
        if (!TextUtils.stringSet((String)(buildNumber = sb.toString()))) {
            return null;
        }
        return Double.valueOf(buildNumber);
    }
}

