/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.xml;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMInputCursor;
import org.codehaus.staxmate.in.SimpleFilter;
import org.jetbrains.annotations.NotNull;

public class SMInputCursorIterable
implements Iterable<SMInputCursor> {
    private static final Logger log = Logger.getLogger(SMInputCursorIterable.class);
    private final Iterator<SMInputCursor> iterator;

    private SMInputCursorIterable(@NotNull SMInputCursor cursor, @NotNull SMFilter filter) throws XMLStreamException {
        this.iterator = new SMInputCursorIterator(cursor, filter);
    }

    @Override
    public Iterator<SMInputCursor> iterator() {
        return this.iterator;
    }

    public static Iterable<SMInputCursor> fromCursor(@NotNull SMInputCursor cursor) throws XMLStreamException {
        return new SMInputCursorIterable(cursor, (SMFilter)new SimpleFilter(SMEvent.START_ELEMENT));
    }

    public static Iterable<SMInputCursor> fromCursor(@NotNull SMInputCursor cursor, @NotNull SMFilter filter) throws XMLStreamException {
        return new SMInputCursorIterable(cursor, filter);
    }

    private class SMInputCursorIterator
    implements Iterator<SMInputCursor> {
        private final SMInputCursor cursor;
        private final SMFilter filter;
        private SMEvent nextEvent;

        private SMInputCursorIterator(@NotNull SMInputCursor cursor, SMFilter filter) throws XMLStreamException {
            this.cursor = cursor;
            this.filter = filter;
        }

        private SMEvent advance() {
            try {
                SMEvent event;
                while ((event = this.cursor.getNext()) != null) {
                    if (!this.filter.accept(event, this.cursor)) continue;
                    return event;
                }
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEvent == null) {
                this.nextEvent = this.advance();
            }
            return this.nextEvent != null;
        }

        @Override
        public SMInputCursor next() {
            if (this.nextEvent == null) {
                this.nextEvent = this.advance();
            }
            this.nextEvent = null;
            return this.cursor;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

