/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.credentials;

import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
public class AnySharedCredentialsProperties
extends SharedCredentialsProperties {
    private final AtlassianModuleProperties atlassianPlugin;
    private final Map<String, Object> configuration;

    private AnySharedCredentialsProperties() {
        this.atlassianPlugin = null;
        this.configuration = Collections.emptyMap();
    }

    public AnySharedCredentialsProperties(AtlassianModuleProperties atlassianPlugin, String name, BambooOidProperties oid, Map<String, Object> configuration) {
        super(name, oid);
        this.atlassianPlugin = atlassianPlugin;
        this.configuration = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(configuration));
        this.validate();
    }

    @Override
    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return this.atlassianPlugin;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnySharedCredentialsProperties that = (AnySharedCredentialsProperties)o;
        return Objects.equals(this.getAtlassianPlugin(), that.getAtlassianPlugin()) && Objects.equals(this.getConfiguration(), that.getConfiguration());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAtlassianPlugin(), this.getConfiguration());
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkNotNull("atlassianPlugin", this.atlassianPlugin);
    }
}

