/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.permission;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.model.permission.PermissionsProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.permission.PermissionValidator;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"deploymentName"})
@Immutable
public class EnvironmentPermissionsProperties
implements EntityProperties {
    private final BambooOidProperties deploymentOid;
    private final String deploymentName;
    private final String environmentName;
    private final PermissionsProperties permissions;

    private EnvironmentPermissionsProperties() {
        this.deploymentOid = null;
        this.deploymentName = null;
        this.environmentName = null;
        this.permissions = null;
    }

    private EnvironmentPermissionsProperties(@Nullable BambooOidProperties deploymentOid, @Nullable String deploymentName, @NotNull String environmentName, @NotNull PermissionsProperties permissions) {
        this.deploymentOid = deploymentOid;
        this.deploymentName = deploymentName;
        this.environmentName = environmentName;
        this.permissions = permissions;
        this.validate();
    }

    public EnvironmentPermissionsProperties(@NotNull String deploymentName, @NotNull String environmentName, @NotNull PermissionsProperties permissions) {
        this(null, deploymentName, environmentName, permissions);
    }

    public EnvironmentPermissionsProperties(@NotNull BambooOidProperties deploymentOid, @NotNull String environmentName, @NotNull PermissionsProperties permissions) {
        this(deploymentOid, null, environmentName, permissions);
    }

    @Override
    public void validate() throws PropertiesValidationException {
        if (this.deploymentName == null && this.deploymentOid == null) {
            throw new PropertiesValidationException("deployment oid or name should be not null");
        }
        ImporterUtils.checkNotBlank("environment name", this.environmentName);
        ImporterUtils.checkNotNull("permissions", this.permissions);
        ImporterUtils.checkNoErrors(PermissionValidator.validatePermissions(this.permissions, PermissionValidator.PermissionTarget.ENVIRONMENT));
    }

    public BambooOidProperties getDeploymentOid() {
        return this.deploymentOid;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public PermissionsProperties getPermissions() {
        return this.permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentPermissionsProperties that = (EnvironmentPermissionsProperties)o;
        return Objects.equals(this.deploymentOid, that.deploymentOid) && Objects.equals(this.deploymentName, that.deploymentName) && Objects.equals(this.environmentName, that.environmentName) && Objects.equals(this.permissions, that.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.deploymentOid, this.deploymentName, this.environmentName, this.permissions);
    }
}

