/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.repository;

import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.repository.VcsChangeDetectionValidator;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class VcsChangeDetectionProperties
implements EntityProperties {
    private final boolean quietPeriodEnabled;
    private final Duration quietPeriod;
    private final int maxRetries;
    private final boolean commitIsolationEnabled;
    private final String changesetFilterPatternRegex;
    private final VcsChangeDetection.FileFilteringOption filterFilePatternOption;
    private final String filterFilePatternRegex;
    private final Map<String, Object> configuration;

    private VcsChangeDetectionProperties() {
        this.quietPeriodEnabled = false;
        this.quietPeriod = Duration.ofSeconds(10L);
        this.maxRetries = 5;
        this.commitIsolationEnabled = false;
        this.changesetFilterPatternRegex = "";
        this.filterFilePatternOption = VcsChangeDetection.FileFilteringOption.NONE;
        this.filterFilePatternRegex = "";
        this.configuration = Collections.emptyMap();
    }

    public VcsChangeDetectionProperties(boolean quietPeriodEnabled, Duration quietPeriod, int maxRetries, boolean commitIsolationEnabled, @NotNull Map<String, Object> configuration, @Nullable String changesetFilterPatternRegex, @Nullable VcsChangeDetection.FileFilteringOption filterFilePatternOption, @Nullable String filterFilePatternRegex) throws PropertiesValidationException {
        this.quietPeriodEnabled = quietPeriodEnabled;
        this.quietPeriod = quietPeriod;
        this.maxRetries = maxRetries;
        this.commitIsolationEnabled = commitIsolationEnabled;
        this.changesetFilterPatternRegex = changesetFilterPatternRegex;
        this.filterFilePatternOption = filterFilePatternOption;
        this.filterFilePatternRegex = filterFilePatternRegex;
        this.configuration = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(configuration));
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsChangeDetectionProperties that = (VcsChangeDetectionProperties)o;
        return this.isQuietPeriodEnabled() == that.isQuietPeriodEnabled() && this.getMaxRetries() == that.getMaxRetries() && this.isCommitIsolationEnabled() == that.isCommitIsolationEnabled() && Objects.equals(this.getQuietPeriod(), that.getQuietPeriod()) && Objects.equals(this.getChangesetFilterPatternRegex(), that.getChangesetFilterPatternRegex()) && Objects.equals((Object)this.getFilterFilePatternOption(), (Object)that.getFilterFilePatternOption()) && Objects.equals(this.getFilterFilePatternRegex(), that.getFilterFilePatternRegex()) && Objects.equals(this.getConfiguration(), that.getConfiguration());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isQuietPeriodEnabled(), this.getQuietPeriod(), this.getMaxRetries(), this.isCommitIsolationEnabled(), this.getChangesetFilterPatternRegex(), this.getFilterFilePatternOption(), this.getFilterFilePatternRegex(), this.getConfiguration()});
    }

    public boolean isQuietPeriodEnabled() {
        return this.quietPeriodEnabled;
    }

    public Duration getQuietPeriod() {
        return this.quietPeriod;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isCommitIsolationEnabled() {
        return this.commitIsolationEnabled;
    }

    @NotNull
    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public String getChangesetFilterPatternRegex() {
        return this.changesetFilterPatternRegex;
    }

    @Nullable
    public VcsChangeDetection.FileFilteringOption getFilterFilePatternOption() {
        return this.filterFilePatternOption;
    }

    @Nullable
    public String getFilterFilePatternRegex() {
        return this.filterFilePatternRegex;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("configuration", this.configuration);
        ImporterUtils.checkNoErrors(VcsChangeDetectionValidator.validate(this));
    }
}

