/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.codegen.annotations.NoArgCallForBooleanValue;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.VariableValidator;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"name", "value"})
@Immutable
public final class VariableProperties
implements EntityProperties {
    public final String name;
    public final String value;
    @NoArgCallForBooleanValue
    public final boolean createOnly;

    private VariableProperties() {
        this.name = null;
        this.value = null;
        this.createOnly = false;
    }

    public VariableProperties(@NotNull String name, @NotNull String value, boolean createOnly) throws PropertiesValidationException {
        this.name = name;
        this.value = value;
        this.createOnly = createOnly;
        this.validate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableProperties that = (VariableProperties)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.isCreateOnly(), that.isCreateOnly());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getValue(), this.isCreateOnly());
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isCreateOnly() {
        return this.createOnly;
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("name", this.name);
        ImporterUtils.checkNotNull("value", this.value);
        ImporterUtils.checkNoErrors(VariableValidator.validate(this));
    }
}

