/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.credentials;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.RootEntityProperties;
import com.atlassian.bamboo.specs.api.model.project.ProjectProperties;
import com.atlassian.bamboo.specs.api.validators.SharedCredentialsValidator;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public abstract class SharedCredentialsProperties
implements RootEntityProperties {
    private final String name;
    private final BambooOidProperties oid;
    private final ProjectProperties project;

    protected SharedCredentialsProperties() {
        this.name = null;
        this.oid = null;
        this.project = null;
    }

    protected SharedCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
        this.project = null;
    }

    protected SharedCredentialsProperties(@NotNull String name, @Nullable BambooOidProperties oid, @Nullable ProjectProperties project) throws PropertiesValidationException {
        this.name = name;
        this.oid = oid;
        this.project = project;
    }

    @NotNull
    public abstract AtlassianModuleProperties getAtlassianPlugin();

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public BambooOidProperties getOid() {
        return this.oid;
    }

    @Nullable
    public ProjectProperties getProject() {
        return this.project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharedCredentialsProperties that = (SharedCredentialsProperties)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getOid(), that.getOid()) && Objects.equals(this.getProject(), that.getProject());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getOid(), this.getProject());
    }

    @Override
    public void validate() {
        ImporterUtils.checkNotNull("name", this.name);
        ImporterUtils.checkNoErrors(SharedCredentialsValidator.validate(this));
    }

    @Override
    @NotNull
    public String humanReadableType() {
        return "shared credentials";
    }

    @Override
    public String humanReadableId() {
        String projectReadableId = "";
        if (this.project != null && this.project.getKey() != null) {
            projectReadableId = String.format(" ProjectKey=" + this.project.getKey().getKey(), new Object[0]);
        }
        return String.format("%s %s%s", "shared credentials", StringUtils.defaultString((String)this.name, (String)"<unknown>"), projectReadableId);
    }
}

