/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.maven;

import com.atlassian.bamboo.specs.api.rsbs.RepositoryStoredSpecsData;
import com.atlassian.bamboo.specs.api.rsbs.RunnerSettings;
import com.atlassian.bamboo.specs.maven.BambooSpecsFileScanner;
import com.atlassian.bamboo.specs.maven.sandbox.SpecsRunner;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="run", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresOnline=true)
@Execute(phase=LifecyclePhase.PACKAGE)
public class RunBambooSpecsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="specsDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(property="specs.yamlDir")
    private File yamlDir;
    @Parameter(property="specs.useRest", defaultValue="true")
    private boolean useRest;
    @Parameter(property="specs.useSecurityManager", defaultValue="false")
    private boolean useSecurityManager;
    @Parameter(property="specs.rs.specsSourceId")
    private Long specsSourceId;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping plan execution as the 'skip' property is set to true");
            return;
        }
        this.getLog().info((CharSequence)("Scanning " + this.outputDirectory + " for classes annotated with Bamboo plan annotation."));
        URLClassLoader classLoader = this.createClassLoader();
        Collection<Path> classFiles = this.getClassFiles(this.outputDirectory.toPath());
        SpecsRunner specsRunner = new SpecsRunner(this.getLog(), classFiles, classLoader, this.getPriorityClasspath());
        RunnerSettings.setRestEnabled((boolean)this.useRest);
        if (this.yamlDir != null) {
            RunnerSettings.setYamlDir((Path)this.yamlDir.toPath());
        }
        if (this.specsSourceId != null) {
            RunnerSettings.setRepositoryStoredSpecsData((RepositoryStoredSpecsData)new RepositoryStoredSpecsData(this.specsSourceId.longValue()));
        }
        specsRunner.runSpecs(this.useSecurityManager);
        if (this.yamlDir != null) {
            this.syncOwnerOfYamlFiles(this.yamlDir.toPath());
        }
    }

    private Collection<Path> getClassFiles(Path root) throws MojoExecutionException {
        Collection<Path> classFiles;
        try {
            classFiles = BambooSpecsFileScanner.getClassFiles(this.getLog(), root);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to find class files in " + this.outputDirectory, (Exception)e);
        }
        return classFiles;
    }

    private URLClassLoader createClassLoader() throws MojoExecutionException {
        URLClassLoader classLoader;
        try {
            Stream<String> priorityClasspath = this.getPriorityClasspath().stream().map(File::getPath);
            URL[] runtimeClasspath = (URL[])Stream.concat(priorityClasspath, this.project.getRuntimeClasspathElements().stream()).map(this::newUrl).toArray(URL[]::new);
            classLoader = new URLClassLoader(runtimeClasspath, Thread.currentThread().getContextClassLoader());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to find dependency", (Exception)((Object)e));
        }
        return classLoader;
    }

    private Set<File> getPriorityClasspath() {
        Artifact specsApi = (Artifact)this.project.getArtifactMap().get("com.atlassian.bamboo:bamboo-specs-api");
        Artifact specs = (Artifact)this.project.getArtifactMap().get("com.atlassian.bamboo:bamboo-specs");
        Artifact snakeYaml = (Artifact)this.project.getArtifactMap().get("org.yaml:snakeyaml");
        return Stream.of(specsApi, specs, snakeYaml).map(Artifact::getFile).collect(Collectors.toSet());
    }

    private URL newUrl(String file) {
        try {
            return new File(file).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to construct classloader", e);
        }
    }

    private void syncOwnerOfYamlFiles(Path yamlDirectory) throws MojoExecutionException {
        try {
            UserPrincipal yamlDirectoryOwner = Files.getFileAttributeView(yamlDirectory, FileOwnerAttributeView.class, new LinkOption[0]).getOwner();
            this.getLog().info((CharSequence)("Updating ownership of files in " + yamlDirectory + " to " + yamlDirectoryOwner));
            try (Stream<Path> walker = Files.walk(yamlDirectory, new FileVisitOption[0]);){
                walker.filter(path -> !Objects.equals(yamlDirectory, path)).forEach(this.updateOwner(yamlDirectoryOwner));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read YAML file owner", (Exception)e);
        }
    }

    private Consumer<Path> updateOwner(UserPrincipal owner) {
        return path -> {
            try {
                Files.getFileAttributeView(path, FileOwnerAttributeView.class, new LinkOption[0]).setOwner(owner);
                this.getLog().debug((CharSequence)("Updating owner of" + path));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to update YAML file owner", e);
            }
        };
    }
}

