/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.task.DownloadItem;
import com.atlassian.bamboo.specs.model.task.ArtifactDownloaderTaskProperties;
import com.atlassian.bamboo.specs.model.task.DownloadItemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ArtifactDownloaderTask
extends Task<ArtifactDownloaderTask, ArtifactDownloaderTaskProperties> {
    private PlanIdentifierProperties sourcePlan;
    private List<DownloadItemProperties> artifacts = new ArrayList<DownloadItemProperties>();

    public ArtifactDownloaderTask sourcePlan(@NotNull PlanIdentifier planIdentifier) {
        ImporterUtils.checkNotNull((String)"planIdentifier", (Object)planIdentifier);
        this.sourcePlan = (PlanIdentifierProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)planIdentifier);
        return this;
    }

    public ArtifactDownloaderTask artifacts(DownloadItem ... artifacts) {
        ImporterUtils.checkNotNull((String)"artifacts", (Object)artifacts);
        Arrays.stream(artifacts).map(DownloadItem::build).forEach(this.artifacts::add);
        return this;
    }

    @NotNull
    protected ArtifactDownloaderTaskProperties build() {
        return new ArtifactDownloaderTaskProperties(this.description, this.taskEnabled, this.sourcePlan, this.artifacts, this.requirements, this.conditions);
    }
}

