/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.builders.task.AbstractDockerTask;
import com.atlassian.bamboo.specs.model.task.docker.DockerBuildImageTaskProperties;
import com.atlassian.bamboo.specs.util.FileUtils;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerBuildImageTask
extends AbstractDockerTask<DockerBuildImageTask, DockerBuildImageTaskProperties> {
    @NotNull
    private String imageName;
    @Nullable
    private String dockerfile;
    @NotNull
    private DockerBuildImageTaskProperties.DockerfileContent dockerfileContent = DockerBuildImageTaskProperties.DockerfileContent.INLINE;
    private boolean useCache = true;
    private boolean saveAsFile;
    @Nullable
    private String imageFilename;

    public DockerBuildImageTask imageName(@NotNull String imageName) {
        this.imageName = imageName;
        return this;
    }

    public DockerBuildImageTask dockerfileInWorkingDir() {
        this.dockerfileContent = DockerBuildImageTaskProperties.DockerfileContent.WORKING_DIR;
        this.dockerfile = null;
        return this;
    }

    public DockerBuildImageTask dockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        this.dockerfileContent = DockerBuildImageTaskProperties.DockerfileContent.INLINE;
        return this;
    }

    public DockerBuildImageTask dockerfileFromPath(@NotNull Path path) {
        return this.dockerfile(FileUtils.readFileContent(path, "Dockerfile path", "Error when reading Dockerfile from path: %s"));
    }

    public DockerBuildImageTask useCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public DockerBuildImageTask saveAsFile(boolean saveAsFile) {
        this.saveAsFile = saveAsFile;
        return this;
    }

    public DockerBuildImageTask imageFilename(String imageFilename) {
        this.imageFilename = imageFilename;
        return this;
    }

    @NotNull
    protected DockerBuildImageTaskProperties build() {
        return new DockerBuildImageTaskProperties(this.description, this.taskEnabled, this.imageName, this.dockerfileContent, this.dockerfile, this.useCache, this.saveAsFile, this.imageFilename, this.environmentVariables, this.workingSubdirectory, this.requirements, this.conditions);
    }
}

