/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.fragment;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.codegen.annotations.Secret;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.codegen.BuilderClassProvider;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.fragment.FieldSetterEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.fragment.SecretSetterEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.fragment.VarargArgumentSetterEmitter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.commons.lang3.StringUtils;

public final class FieldSetterEmitterFactory {
    private FieldSetterEmitterFactory() {
    }

    private static Object getFirstElement(Iterable<?> value) {
        return value.iterator().next();
    }

    private static CodeEmitter<Object> findSetterForField(Class<?> builderClass, Field field, String name, Object value, boolean strictNameMatch) throws CodeGenerationException {
        Class<Object> type = field.getType().isPrimitive() ? field.getType() : value.getClass();
        String expectedMethodName = name;
        Class<Object> argumentType = type;
        Class arrayElementClass = null;
        if (EntityProperties.class.isAssignableFrom(type)) {
            argumentType = BuilderClassProvider.findBuilderClass(type);
            if (argumentType == null) {
                throw new CodeGenerationException("Could not find builder for field " + field.getName() + " of class " + type.getCanonicalName());
            }
            if (!strictNameMatch) {
                expectedMethodName = expectedMethodName.replace("Properties", "");
            }
        } else if (Iterable.class.isAssignableFrom(argumentType) && EntityProperties.class.isAssignableFrom(arrayElementClass = FieldSetterEmitterFactory.getFirstElement((Iterable)value).getClass())) {
            arrayElementClass = BuilderClassProvider.findBuilderClass(arrayElementClass);
        }
        int matchingMethodCount = 0;
        Method candidateMethod = null;
        for (Method method : builderClass.getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getParameters().length != 1) continue;
            Parameter parameter = method.getParameters()[0];
            if (expectedMethodName.equals(method.getName()) && FieldSetterEmitterFactory.isAssignableToParameterType(argumentType, parameter)) {
                return FieldSetterEmitterFactory.createFieldSetterEmitter(field, method);
            }
            if (expectedMethodName.equals(method.getName()) && Iterable.class.isAssignableFrom(argumentType)) {
                if (!parameter.getType().isArray() || !parameter.getType().getComponentType().isAssignableFrom(arrayElementClass)) continue;
                return new VarargArgumentSetterEmitter(method.getName());
            }
            if (!strictNameMatch && EntityPropertiesBuilder.class.isAssignableFrom(argumentType) && FieldSetterEmitterFactory.isAssignableToParameterType(argumentType, parameter)) {
                ++matchingMethodCount;
                candidateMethod = method;
                continue;
            }
            if (strictNameMatch || !StringUtils.containsIgnoreCase((CharSequence)method.getName(), (CharSequence)name) || !FieldSetterEmitterFactory.isAssignableToParameterType(argumentType, parameter)) continue;
            ++matchingMethodCount;
            candidateMethod = method;
        }
        if (matchingMethodCount == 1) {
            return FieldSetterEmitterFactory.createFieldSetterEmitter(field, candidateMethod);
        }
        throw new CodeGenerationException("Could not find suitable setter for field " + field.getName() + " expected method called " + expectedMethodName);
    }

    private static CodeEmitter<Object> createFieldSetterEmitter(Field field, Method method) {
        return field.isAnnotationPresent(Secret.class) ? new SecretSetterEmitter(method.getName()) : new FieldSetterEmitter(method.getName());
    }

    private static boolean isAssignableToParameterType(Class<?> valueType, Parameter parameter) {
        Class<?> parameterType = parameter.getType();
        if (parameterType.isAssignableFrom(valueType)) {
            return true;
        }
        if (parameterType == Boolean.class && valueType == Boolean.TYPE) {
            return true;
        }
        if (parameterType == Long.class && valueType == Long.TYPE) {
            return true;
        }
        return parameterType == Integer.class && valueType == Integer.TYPE;
    }

    public static CodeEmitter<Object> fieldSetterEmitterFor(CodeGenerationContext context, Class<?> builderClass, Field field, Object fieldValue) throws CodeGenerationException {
        CodeEmitter codeEmitter = CodeGenerationUtils.findEmitterByAnnotation(field);
        if (codeEmitter != null) {
            return codeEmitter;
        }
        if (field.isAnnotationPresent(Setter.class)) {
            String setterName = field.getAnnotation(Setter.class).value();
            return FieldSetterEmitterFactory.findSetterForField(builderClass, field, setterName, fieldValue, true);
        }
        return FieldSetterEmitterFactory.findSetterForField(builderClass, field, field.getName(), fieldValue, false);
    }
}

