/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.notification;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.apache.commons.validator.routines.EmailValidator;
import org.jetbrains.annotations.NotNull;

@ConstructFrom(value={"email"})
public class EmailRecipientProperties
extends NotificationRecipientProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.system.notifications:recipient.email");
    private final String email;

    private EmailRecipientProperties() {
        this.email = null;
    }

    public EmailRecipientProperties(String email) {
        this.email = email;
        this.validate();
    }

    public String getEmail() {
        return this.email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EmailRecipientProperties that = (EmailRecipientProperties)((Object)o);
        return Objects.equals(this.getEmail(), that.getEmail());
    }

    public int hashCode() {
        return Objects.hash(this.getEmail());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"emailRecipient");
        ImporterUtils.checkThat((ValidationContext)context, (boolean)EmailValidator.getInstance().isValid(this.email), (String)"%s is not a valid email", (Object[])new Object[]{this.email});
    }
}

