/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.git;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import com.atlassian.bamboo.specs.model.repository.git.AuthenticationProperties;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.Nullable;

@ConstructFrom(value={"username"})
@Immutable
public final class UserPasswordAuthenticationProperties
implements AuthenticationProperties {
    private final String username;
    private final String password;

    private UserPasswordAuthenticationProperties() {
        this.username = null;
        this.password = null;
    }

    public UserPasswordAuthenticationProperties(String username, @Nullable String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void validate() {
        ImporterUtils.checkNotNull((String)"username", (Object)this.username);
        ValidationContext context = ValidationContext.of((String)"User-password authentication");
        ArrayList errors = new ArrayList();
        if (!ValidationUtils.containsBambooVariable((String)this.username)) {
            ValidationUtils.validateNotContainsRelaxedXssRelatedCharacters((ValidationContext)context.with("Username"), (String)this.username).ifPresent(errors::add);
            ValidationUtils.validateNotContainsShellInjectionRelatedCharacters((ValidationContext)context.with("Username"), (String)this.username).ifPresent(errors::add);
        }
        ImporterUtils.checkNoErrors(errors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPasswordAuthenticationProperties that = (UserPasswordAuthenticationProperties)o;
        return Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword());
    }

    public int hashCode() {
        return Objects.hash(this.getUsername(), this.getPassword());
    }
}

