/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task.docker;

import com.atlassian.bamboo.specs.api.codegen.annotations.Builder;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.DockerBuildImageTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.DockerBuildImageEmitter;
import com.atlassian.bamboo.specs.model.task.docker.AbstractDockerTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Builder(value=DockerBuildImageTask.class)
@CodeGenerator(value=DockerBuildImageEmitter.class)
@Immutable
public final class DockerBuildImageTaskProperties
extends AbstractDockerTaskProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Docker build image task: ");
    @NotNull
    private String imageName;
    @NotNull
    private DockerfileContent dockerfileContent;
    @Nullable
    private String dockerfile;
    private boolean useCache;
    private boolean saveAsFile;
    @Nullable
    private String imageFilename;

    protected DockerBuildImageTaskProperties() {
    }

    public DockerBuildImageTaskProperties(@Nullable String description, boolean enabled, @NotNull String imageName, @NotNull DockerfileContent dockerfileContent, @Nullable String dockerfile, boolean useCache, boolean saveAsFile, @Nullable String imageFileName, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, environmentVariables, workingSubdirectory, requirements, conditions);
        this.imageName = imageName;
        this.dockerfileContent = dockerfileContent;
        this.dockerfile = dockerfile;
        this.useCache = useCache;
        this.saveAsFile = saveAsFile;
        this.imageFilename = imageFileName;
        this.validate();
    }

    @NotNull
    public String getImageName() {
        return this.imageName;
    }

    @NotNull
    public DockerfileContent getDockerfileContent() {
        return this.dockerfileContent;
    }

    @Nullable
    public String getDockerfile() {
        return this.dockerfile;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public boolean isSaveAsFile() {
        return this.saveAsFile;
    }

    @Nullable
    public String getImageFilename() {
        return this.imageFilename;
    }

    public void validate() {
        super.validate();
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"imageName", (String)this.imageName);
        if (this.saveAsFile) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"imageFilename", (String)this.imageFilename);
        }
        if (this.dockerfileContent == DockerfileContent.INLINE) {
            ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"Dockerfile content", (String)this.dockerfile);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerBuildImageTaskProperties that = (DockerBuildImageTaskProperties)((Object)o);
        return this.useCache == that.useCache && this.saveAsFile == that.saveAsFile && Objects.equals(this.imageName, that.imageName) && this.dockerfileContent == that.dockerfileContent && Objects.equals(this.dockerfile, that.dockerfile) && Objects.equals(this.imageFilename, that.imageFilename);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.imageName, this.dockerfileContent, this.dockerfile, this.useCache, this.saveAsFile, this.imageFilename});
    }

    public static enum DockerfileContent {
        WORKING_DIR,
        INLINE;

    }
}

