/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.CustomYamlers;
import com.atlassian.bamboo.specs.util.WhitelistedYamlConstructor;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.representer.Representer;

public final class Yamlizator {
    private static final DumperOptions BLOCK_STYLE_DUMPER = new DumperOptions();
    private static final Field FIELD_FIELD;
    private static final Comparator<Property> CLASS_SCOPED_ORDER;

    private Yamlizator() {
    }

    public static Yaml getYaml() {
        Yaml yaml = new Yaml((BaseConstructor)Yamlizator.getConstructor(), Yamlizator.getRepresenter(), BLOCK_STYLE_DUMPER);
        yaml.setBeanAccess(BeanAccess.FIELD);
        return yaml;
    }

    private static WhitelistedYamlConstructor getConstructor() {
        return new WhitelistedYamlConstructor();
    }

    @NotNull
    private static Representer getRepresenter() {
        return new Representer(){
            {
                for (CustomYamlers.CustomYamler customYamler : CustomYamlers.YAMLERS) {
                    this.representers.put(customYamler.getYamledClass(), customYamler.getRepresenter());
                }
            }

            protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
                Set properties = this.getPropertyUtils().getProperties(type);
                return properties.stream().sorted(CLASS_SCOPED_ORDER).collect(Collectors.toCollection(LinkedHashSet::new));
            }
        };
    }

    @Nullable
    private static FieldProperty asFieldProperty(Property property) {
        if (property instanceof FieldProperty) {
            return (FieldProperty)property;
        }
        return null;
    }

    @NotNull
    private static Class<?> getDeclaringClass(FieldProperty fieldProperty) {
        try {
            return ((Field)FIELD_FIELD.get(fieldProperty)).getDeclaringClass();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        BLOCK_STYLE_DUMPER.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        BLOCK_STYLE_DUMPER.setExplicitStart(true);
        BLOCK_STYLE_DUMPER.setExplicitEnd(true);
        BLOCK_STYLE_DUMPER.setAllowReadOnlyProperties(true);
        try {
            FIELD_FIELD = FieldProperty.class.getDeclaredField("field");
            FIELD_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
        CLASS_SCOPED_ORDER = (o1, o2) -> {
            int classCompare;
            Class<?> class2;
            FieldProperty fp1 = Yamlizator.asFieldProperty(o1);
            FieldProperty fp2 = Yamlizator.asFieldProperty(o2);
            if (fp1 == null && fp2 != null) {
                return -1;
            }
            if (fp1 != null && fp2 == null) {
                return 1;
            }
            if (fp1 == null) {
                return 0;
            }
            Class<?> class1 = Yamlizator.getDeclaringClass(fp1);
            if (!class1.equals(class2 = Yamlizator.getDeclaringClass(fp2))) {
                if (class2.isAssignableFrom(class1)) {
                    return 1;
                }
                if (class1.isAssignableFrom(class2)) {
                    return -1;
                }
            }
            if ((classCompare = class1.getName().compareTo(class2.getName())) != 0) {
                return classCompare;
            }
            return fp1.getName().compareTo(fp2.getName());
        };
    }
}

