/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.model.task.AntTaskProperties;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntTask
extends Task<AntTask, AntTaskProperties> {
    @NotNull
    private String target;
    @Nullable
    private String buildFile;
    @Nullable
    private String environmentVariables;
    @Nullable
    private String jdk;
    @Nullable
    private String label;
    private boolean hasTests;
    @Nullable
    private String testResultsDirectory;
    @Nullable
    private String workingSubdirectory;

    public AntTask target(@NotNull String target) {
        this.target = target;
        return this;
    }

    public AntTask buildFile(String buildFile) {
        this.buildFile = buildFile;
        return this;
    }

    public AntTask environmentVariables(String environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public AntTask jdk(String jdk) {
        this.jdk = jdk;
        return this;
    }

    public AntTask executableLabel(@NotNull String label) {
        this.label = label;
        return this;
    }

    public AntTask hasTests(boolean hasTests) {
        this.hasTests = hasTests;
        return this;
    }

    public AntTask testResultsPath(String testResultsDirectory) {
        this.testResultsDirectory = testResultsDirectory;
        return this;
    }

    public AntTask workingSubdirectory(String workingSubdirectory) {
        this.workingSubdirectory = workingSubdirectory;
        return this;
    }

    @NotNull
    protected AntTaskProperties build() {
        return new AntTaskProperties(this.description, this.taskEnabled, this.target, this.buildFile, this.environmentVariables, this.jdk, this.label, this.hasTests, this.testResultsDirectory, this.workingSubdirectory, this.requirements, this.conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AntTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AntTask antTask = (AntTask)((Object)o);
        return this.hasTests == antTask.hasTests && this.target.equals(antTask.target) && Objects.equals(this.buildFile, antTask.buildFile) && Objects.equals(this.environmentVariables, antTask.environmentVariables) && Objects.equals(this.jdk, antTask.jdk) && Objects.equals(this.label, antTask.label) && Objects.equals(this.testResultsDirectory, antTask.testResultsDirectory) && Objects.equals(this.workingSubdirectory, antTask.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.target, this.buildFile, this.environmentVariables, this.jdk, this.label, this.hasTests, this.testResultsDirectory, this.workingSubdirectory);
    }
}

