/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.plan;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.repository.PlanRepositoryLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsRepositoryProperties;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PlanRepositoriesEmitter
implements CodeEmitter<Iterable<PlanRepositoryLinkProperties>> {
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull Iterable<PlanRepositoryLinkProperties> value) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> valuesAndFails = new ArrayList<String>();
        HashSet<Integer> indicesOfFails = new HashSet<Integer>();
        int index = 0;
        RepositoryLinkType linkType = RepositoryLinkType.LINKED;
        for (PlanRepositoryLinkProperties planRepositoryLink : value) {
            VcsRepositoryProperties repository = planRepositoryLink.getRepositoryDefinition();
            if (repository instanceof PlanRepositoryLinkProperties.LinkedGlobalRepository) {
                if (linkType == RepositoryLinkType.PLAN) {
                    this.dumpCurrentData(builder, context, linkType, valuesAndFails, indicesOfFails);
                    index = 0;
                    linkType = RepositoryLinkType.LINKED;
                }
                valuesAndFails.add(ValueEmitterFactory.emitterFor(repository.getParent()).emitCode(context, (Object)repository.getParent()));
                ++index;
                continue;
            }
            if (linkType == RepositoryLinkType.LINKED) {
                this.dumpCurrentData(builder, context, linkType, valuesAndFails, indicesOfFails);
                index = 0;
                linkType = RepositoryLinkType.PLAN;
            }
            boolean fail = false;
            try {
                CodeEmitter<VcsRepositoryProperties> codeEmitter = ValueEmitterFactory.emitterFor(repository);
                context.incIndentation();
                String repositoryCode = codeEmitter.emitCode(context, (Object)repository);
                context.decIndentation();
                valuesAndFails.add(repositoryCode);
            }
            catch (CodeGenerationException e) {
                valuesAndFails.add("//" + e.getMessage());
                indicesOfFails.add(index);
            }
            ++index;
        }
        this.dumpCurrentData(builder, context, linkType, valuesAndFails, indicesOfFails);
        return builder.toString();
    }

    private void dumpCurrentData(StringBuilder builder, CodeGenerationContext context, RepositoryLinkType linkType, List<String> valuesAndFails, Set<Integer> indicesOfFails) {
        if (valuesAndFails.isEmpty()) {
            return;
        }
        if (linkType == RepositoryLinkType.LINKED) {
            builder.append(".linkedRepositories(");
        } else {
            builder.append(".planRepositories(");
        }
        context.incIndentation();
        CodeGenerationUtils.appendCommaSeparatedList(context, builder, valuesAndFails, indicesOfFails);
        context.decIndentation();
        builder.append(")").append(context.newLine());
        valuesAndFails.clear();
        indicesOfFails.clear();
    }

    private static enum RepositoryLinkType {
        LINKED,
        PLAN;

    }
}

