/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Function;

public final class IsolatedExecutor<T, R> {
    private final BlockingQueue<T> inputQueue = new SynchronousQueue<T>();
    private final BlockingQueue<Either<R>> resultQueue = new SynchronousQueue<Either<R>>();
    private final Thread executionThread;

    public Thread getThread() {
        return this.executionThread;
    }

    public IsolatedExecutor(final Function<T, R> inputProcessor, String name) {
        this.executionThread = new Thread(name){

            @Override
            public void run() {
                while (true) {
                    Object input = IsolatedExecutor.this.take(IsolatedExecutor.this.inputQueue);
                    try {
                        IsolatedExecutor.this.putResult(Either.right(inputProcessor.apply(input)));
                        continue;
                    }
                    catch (Throwable e) {
                        IsolatedExecutor.this.putResult(Either.left(e));
                        continue;
                    }
                    break;
                }
            }
        };
        this.executionThread.setDaemon(true);
    }

    public void start() {
        this.executionThread.start();
    }

    private T take(BlockingQueue<T> queue) {
        try {
            return queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void putResult(Either<R> result) {
        try {
            this.resultQueue.put(result);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public R execute(T task) throws Throwable {
        try {
            this.inputQueue.put(task);
            return this.resultQueue.take().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class Either<R> {
        private final R result;
        private final Throwable exception;

        private Either(R result, Throwable exception) {
            this.result = result;
            this.exception = exception;
        }

        private static <R> Either<R> right(R result) {
            return new Either<R>(result, null);
        }

        private static <R> Either<R> left(Throwable e) {
            return new Either<Object>(null, e);
        }

        public R get() throws Throwable {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

