/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsScope;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.model.task.BaseSshTaskProperties;
import org.jetbrains.annotations.NotNull;

class BaseSshTaskAuthenticationEmitter {
    BaseSshTaskAuthenticationEmitter() {
    }

    String emitCodeForAuthentication(@NotNull BaseSshTaskProperties entity, CodeGenerationContext context) {
        SharedCredentialsIdentifierProperties sharedCredentials = entity.getSharedCredentialsIdentifierProperties();
        if (sharedCredentials == null) {
            switch (entity.getAuthenticationType()) {
                case PASSWORD: {
                    return String.format(".authenticateWithPassword(\"%s\")", entity.getPassword());
                }
                case KEY_WITHOUT_PASSPHRASE: {
                    return String.format(".authenticateWithKey(\"%s\")", entity.getKey());
                }
                case KEY_WITH_PASSPHRASE: {
                    return String.format(".authenticateWithKeyWithPassphrase(\"%s\", \"%s\")", entity.getKey(), entity.getPassphrase());
                }
            }
            return ".unknownAuthorization() //" + (Object)((Object)entity.getAuthenticationType());
        }
        switch (entity.getAuthenticationType()) {
            case PASSWORD: {
                return String.format(".authenticateWithUsernamePasswordSharedCredentials(new %s(\"%s\").scope(%s.%s))", context.importClassName(SharedCredentialsIdentifier.class), sharedCredentials.getName(), context.importClassName(SharedCredentialsScope.class), sharedCredentials.getScope());
            }
            case KEY_WITHOUT_PASSPHRASE: 
            case KEY_WITH_PASSPHRASE: {
                return String.format(".authenticateWithSshSharedCredentials(new %s(\"%s\").scope(%s.%s))", context.importClassName(SharedCredentialsIdentifier.class), sharedCredentials.getName(), context.importClassName(SharedCredentialsScope.class), sharedCredentials.getScope());
            }
        }
        return ".unknownSharedCredentialsAuthorization() //" + (Object)((Object)entity.getAuthenticationType());
    }
}

