/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.builders.task.DockerRunContainerTask;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.docker.DockerRunContainerTaskProperties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerRunContainerEmitter
extends EntityPropertiesEmitter<DockerRunContainerTaskProperties> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull DockerRunContainerTaskProperties entity) throws CodeGenerationException {
        this.builderClass = DockerRunContainerTask.class;
        this.fieldsToSkip.add("portMappings");
        this.fieldsToSkip.add("volumeMappings");
        String builderCode = super.emitCode(context, entity);
        try {
            context.incIndentation();
            String string = String.format("%s%s%s%s.clearVolumeMappings()%s", builderCode, context.newLine(), this.emitPortMappings(context, entity), context.newLine(), this.emitVolumeMappings(context, entity));
            return string;
        }
        finally {
            context.decIndentation();
        }
    }

    private String emitPortMappings(CodeGenerationContext context, DockerRunContainerTaskProperties entity) {
        String portMappingCode = entity.getPortMappings().entrySet().stream().map(mapping -> String.format("appendPortMapping(%d, %d)", mapping.getKey(), mapping.getValue())).collect(Collectors.joining(context.newLine() + "."));
        return StringUtils.isBlank((CharSequence)portMappingCode) ? "" : String.format(".%s", portMappingCode);
    }

    private String emitVolumeMappings(CodeGenerationContext context, DockerRunContainerTaskProperties entity) {
        return entity.getVolumeMappings().isEmpty() ? "" : context.newLine() + entity.getVolumeMappings().entrySet().stream().map(mapping -> String.format("appendVolumeMapping(\"%s\", \"%s\")", mapping.getKey(), mapping.getValue())).collect(Collectors.joining(context.newLine() + ".", ".", ""));
    }
}

