/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class DownloadItemProperties
implements EntityProperties {
    @Setter(value="artifact")
    private final String artifactName;
    private final boolean allArtifacts;
    private final String path;

    private DownloadItemProperties() {
        this.artifactName = null;
        this.path = "";
        this.allArtifacts = false;
    }

    public DownloadItemProperties(String artifactName, boolean allArtifacts, String path) {
        this.artifactName = artifactName;
        this.allArtifacts = allArtifacts;
        this.path = path;
        this.validate();
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public boolean isAllArtifacts() {
        return this.allArtifacts;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadItemProperties that = (DownloadItemProperties)o;
        return this.isAllArtifacts() == that.isAllArtifacts() && Objects.equals(this.getArtifactName(), that.getArtifactName()) && Objects.equals(this.getPath(), that.getPath());
    }

    public int hashCode() {
        return Objects.hash(this.getArtifactName(), this.isAllArtifacts(), this.getPath());
    }

    public void validate() {
        ValidationContext context = ValidationContext.of((String)"Artifact downloader task").with("Download spec");
        if (!this.allArtifacts && StringUtils.isBlank((CharSequence)this.artifactName)) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(context, "Artifact must be specified")));
        }
        if (this.allArtifacts && StringUtils.isNotBlank((CharSequence)this.artifactName)) {
            throw new PropertiesValidationException(Collections.singletonList(new ValidationProblem(context, "Cannot pick specific artifacts when all artifacts is selected")));
        }
        ImporterUtils.checkRequired((ValidationContext)context.with("path"), (Object)this.path);
    }
}

