/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.GruntTask;
import com.atlassian.bamboo.specs.model.task.BaseNodeTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class GruntTaskProperties
extends BaseNodeTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.builder.grunt");
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Grunt task");
    @NotNull
    private String gruntCliExecutable = GruntTask.DEFAULT_GRUNT_CLI_EXECUTABLE;
    @Nullable
    private String task;
    @Nullable
    private String gruntfile;

    protected GruntTaskProperties() {
    }

    public GruntTaskProperties(@Nullable String description, boolean enabled, @NotNull String nodeExecutable, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull String gruntCliExecutable, @Nullable String task, @Nullable String gruntfile, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, nodeExecutable, environmentVariables, workingSubdirectory, requirements, conditions);
        this.gruntCliExecutable = gruntCliExecutable;
        this.task = task;
        this.gruntfile = gruntfile;
        this.validate();
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.gruntCliExecutable), (String)"Grunt CLI executable is not defined", (Object[])new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GruntTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GruntTaskProperties that = (GruntTaskProperties)((Object)o);
        return Objects.equals(this.gruntCliExecutable, that.gruntCliExecutable) && Objects.equals(this.task, that.task) && Objects.equals(this.gruntfile, that.gruntfile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gruntCliExecutable, this.task, this.gruntfile);
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Override
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @NotNull
    public String getGruntCliExecutable() {
        return this.gruntCliExecutable;
    }

    @Nullable
    public String getTask() {
        return this.task;
    }

    @Nullable
    public String getGruntfile() {
        return this.gruntfile;
    }
}

