/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.bonnie.DirectoryUtil;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LoggingReentrantLock;
import com.atlassian.bonnie.LuceneConnectionClosedException;
import com.atlassian.bonnie.LuceneException;
import com.atlassian.bonnie.SearchTokenExpiredException;
import com.atlassian.bonnie.search.SearcherInitialisation;
import com.atlassian.bonnie.upgrader.LuceneIndexUpgrader;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexUpgrader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.search.DelayCloseIndexSearcher;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherLifetimeManager;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneConnection
implements ILuceneConnection {
    private static final Logger log = LoggerFactory.getLogger(LuceneConnection.class);
    private static final SearcherInitialisation NOOP_SEARCHER_INITIALISATION = new SearcherInitialisation(){

        @Override
        public void initialise(IndexSearcher searcher) {
        }
    };
    private final Analyzer analyzerForIndexing;
    private final ILuceneConnection.Configuration configuration;
    private final SearcherInitialisation searcherInitialisation;
    private final Lock indexWriteLock = new LoggingReentrantLock("indexWriteLock");
    private final Lock searcherRefreshLock = new LoggingReentrantLock("searcherRefreshLock");
    private final ReadWriteLock searcherLifetimeManagerLock = new ReentrantReadWriteLock();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicBoolean writerIsClosed = new AtomicBoolean(false);
    private final AtomicBoolean batchMode = new AtomicBoolean(false);
    private IndexWriter writer;
    private final SearcherManager searcherManager;
    private final SearcherLifetimeManager searcherLifetimeManager;
    private static final String TRACKED_SEARCHERS_PRUNE_DELAY = "atlassian.indexing.tracked.searchers.prune.delay";
    private volatile DelayCloseIndexSearcher searcher;
    private ScheduledExecutorService scheduledExecutorService;

    public LuceneConnection(Directory directory, Analyzer analyzer, ILuceneConnection.Configuration configuration, SearcherInitialisation searcherInitialisation) {
        this.analyzerForIndexing = analyzer;
        this.configuration = configuration;
        this.searcherInitialisation = searcherInitialisation;
        try {
            this.ensureLockOnDirectory(directory);
            this.ensureCorrectIndexFormat(directory);
            this.ensureIndexExists(directory);
            this.writer = new IndexWriter(directory, new IndexWriterConfig(BonnieConstants.LUCENE_VERSION, this.analyzerForIndexing));
            this.searcherLifetimeManager = new SearcherLifetimeManager();
            this.searcherManager = this.newSearcherManager();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        this.scheduleIndexSearcherPruneJob(configuration);
    }

    public LuceneConnection(Directory directory, Analyzer analyzer, ILuceneConnection.Configuration configuration) {
        this(directory, analyzer, configuration, NOOP_SEARCHER_INITIALISATION);
    }

    public LuceneConnection(Directory directory, Analyzer analyzer) {
        this(directory, analyzer, DEFAULT_CONFIGURATION);
    }

    public LuceneConnection(File path, Analyzer analyzer, ILuceneConnection.Configuration configuration, SearcherInitialisation searcherInitialisation) {
        this(DirectoryUtil.getDirectory(path), analyzer, configuration, searcherInitialisation);
    }

    public LuceneConnection(File path, Analyzer analyzer, ILuceneConnection.Configuration configuration) {
        this(DirectoryUtil.getDirectory(path), analyzer, configuration);
    }

    public LuceneConnection(File path, Analyzer analyzer) {
        this(path, analyzer, DEFAULT_CONFIGURATION);
    }

    @Override
    public int getNumDocs() {
        return (Integer)this.withReader(new ILuceneConnection.ReaderAction(){

            @Override
            public Object perform(IndexReader reader) {
                return reader.numDocs();
            }
        });
    }

    private SearcherManager newSearcherManager() throws IOException {
        final SearcherManager newSearchManager = new SearcherManager(this.writer, true, new SearcherFactory(){

            public IndexSearcher newSearcher(IndexReader reader) throws IOException {
                IndexSearcher indexSearcher = super.newSearcher(reader);
                LuceneConnection.this.searcherInitialisation.initialise(indexSearcher);
                return indexSearcher;
            }
        });
        newSearchManager.addListener(new ReferenceManager.RefreshListener(){

            public void beforeRefresh() throws IOException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterRefresh(boolean didRefresh) throws IOException {
                if (didRefresh) {
                    IndexSearcher indexSearcher = (IndexSearcher)newSearchManager.acquire();
                    try {
                        LuceneConnection.this.record(indexSearcher);
                    }
                    finally {
                        newSearchManager.release((Object)indexSearcher);
                    }
                }
            }
        });
        return newSearchManager;
    }

    private void scheduleIndexSearcherPruneJob(final ILuceneConnection.Configuration configuration) {
        long indexSearcherPruneDelay = Long.getLong(TRACKED_SEARCHERS_PRUNE_DELAY, configuration.getIndexSearcherPruneDelay());
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("lucene-tracked-searchers-pruner-" + thread.getName());
                return thread;
            }
        });
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    LuceneConnection.this.searcherLifetimeManager.prune((SearcherLifetimeManager.Pruner)new SearcherLifetimeManager.PruneByAge((double)configuration.getIndexSearcherMaxAge()));
                }
                catch (Exception e) {
                    log.error("Error pruning IndexSearchers.", (Throwable)e);
                }
            }
        }, 0L, indexSearcherPruneDelay, TimeUnit.SECONDS);
    }

    @Override
    public void optimize() throws LuceneException {
        this.withWriter(new ILuceneConnection.WriterAction(){

            @Override
            public void perform(IndexWriter writer) throws IOException {
                writer.forceMerge(1, true);
            }
        });
    }

    @Override
    public void close() throws LuceneException {
        this.assertNotClosed();
        try {
            this.closeWriter();
            this.searcherManager.close();
            this.isClosed.set(true);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        this.shutdownScheduledExecutorService();
        this.closeSearcherLifetimeManager();
    }

    private void shutdownScheduledExecutorService() {
        this.scheduledExecutorService.shutdown();
        try {
            if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.scheduledExecutorService.shutdownNow();
                if (!this.scheduledExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.debug("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            this.scheduledExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSearcherLifetimeManager() {
        this.searcherLifetimeManagerLock.writeLock().lock();
        try {
            this.searcherLifetimeManager.close();
        }
        catch (IOException e) {
            log.debug("Error closing searcherLifetimeManager", (Throwable)e);
        }
        finally {
            this.searcherLifetimeManagerLock.writeLock().unlock();
        }
    }

    @Override
    public void closeWriter() throws LuceneException {
        this.assertNotClosed();
        this.assertWriterNotClosed();
        try {
            this.writer.close();
            this.writerIsClosed.set(true);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }

    private void assertNotClosed() throws LuceneException {
        if (this.isClosed.get()) {
            throw new LuceneConnectionClosedException("Cannot operate on closed " + this.getClass().getSimpleName());
        }
    }

    private void assertWriterNotClosed() throws LuceneException {
        if (this.writerIsClosed.get()) {
            throw new LuceneConnectionClosedException("Cannot operate on closed IndexWriter");
        }
    }

    @Override
    public void withSearch(ILuceneConnection.SearcherAction action) throws LuceneException {
        this.assertNotClosed();
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = (IndexSearcher)this.searcherManager.acquire();
            action.perform(indexSearcher);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            try {
                if (indexSearcher != null) {
                    this.searcherManager.release((Object)indexSearcher);
                }
            }
            catch (IOException e) {
                throw new LuceneException(e);
            }
        }
    }

    @Override
    public <T> T withSearcher(ILuceneConnection.SearcherWithTokenAction<T> action) throws LuceneException {
        this.assertNotClosed();
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = (IndexSearcher)this.searcherManager.acquire();
            long searchToken = this.record(indexSearcher);
            T t = action.perform(indexSearcher, searchToken);
            return t;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            try {
                if (indexSearcher != null) {
                    this.searcherManager.release((Object)indexSearcher);
                }
            }
            catch (IOException e) {
                throw new LuceneException(e);
            }
        }
    }

    private long record(IndexSearcher indexSearcher) throws LuceneException {
        long searchToken;
        this.searcherLifetimeManagerLock.readLock().lock();
        try {
            searchToken = this.searcherLifetimeManager.record(indexSearcher);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.searcherLifetimeManagerLock.readLock().unlock();
        }
        return searchToken;
    }

    @Override
    public <T> T withSearcher(long searchToken, ILuceneConnection.SearcherWithTokenAction<T> action) throws SearchTokenExpiredException {
        this.assertNotClosed();
        if (searchToken <= 0L) {
            throw new IllegalArgumentException("searchToken must be greater than 0");
        }
        IndexSearcher indexSearcher = this.searcherLifetimeManager.acquire(searchToken);
        if (indexSearcher == null) {
            throw new SearchTokenExpiredException(searchToken);
        }
        try {
            T t = action.perform(indexSearcher, searchToken);
            return t;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            try {
                this.searcherLifetimeManager.release(indexSearcher);
            }
            catch (IOException e) {
                throw new LuceneException(e);
            }
        }
    }

    @Override
    public Object withReader(final ILuceneConnection.ReaderAction action) throws LuceneException {
        final AtomicReference result = new AtomicReference();
        this.withSearch(new ILuceneConnection.SearcherAction(){

            @Override
            public void perform(IndexSearcher searcher) throws IOException {
                result.set(action.perform(searcher.getIndexReader()));
            }
        });
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withWriter(ILuceneConnection.WriterAction action) throws LuceneException {
        this.assertWriterNotClosed();
        this.indexWriteLock.lock();
        try {
            this.configureIndexWriter(this.writer, this.configuration);
            try {
                action.perform(this.writer);
            }
            catch (IOException e) {
                throw new LuceneException(e);
            }
            this.commitAndRefreshSearcher();
        }
        finally {
            this.indexWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withBatchUpdate(ILuceneConnection.BatchUpdateAction action) {
        this.assertNotClosed();
        this.assertWriterNotClosed();
        this.indexWriteLock.lock();
        try {
            this.batchMode.set(true);
            try {
                action.perform();
            }
            catch (Exception e) {
                throw new LuceneException(e);
            }
            finally {
                this.batchMode.set(false);
            }
            this.commitAndRefreshSearcher();
        }
        finally {
            this.indexWriteLock.unlock();
        }
    }

    private void commitAndRefreshSearcher() {
        if (this.batchMode.get()) {
            return;
        }
        this.searcherRefreshLock.lock();
        try {
            this.writer.commit();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (IOException e) {
            throw new LuceneException("Error refreshing index searcher", e);
        }
        finally {
            this.searcherRefreshLock.unlock();
        }
    }

    private void closeReader(IndexReader reader) {
        block4: {
            if (reader == null) {
                return;
            }
            if (log.isDebugEnabled() && reader instanceof DirectoryReader) {
                log.debug("Closing index reader: " + ((DirectoryReader)reader).directory());
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                if (!(reader instanceof DirectoryReader)) break block4;
                log.error("Error closing reader: " + ((DirectoryReader)reader).directory(), (Throwable)e);
            }
        }
    }

    private void configureIndexWriter(IndexWriter indexWriter, ILuceneConnection.Configuration configuration) {
        LiveIndexWriterConfig config = indexWriter.getConfig();
        MergePolicy mergePolicy = config.getMergePolicy();
        if (mergePolicy instanceof TieredMergePolicy) {
            TieredMergePolicy tieredMergePolicy = (TieredMergePolicy)config.getMergePolicy();
        }
        config.setUseCompoundFile(configuration.isCompoundIndexFileFormat());
        if (this.batchMode.get()) {
            config.setMaxBufferedDocs(configuration.getBatchMaxBufferedDocs());
        } else {
            config.setMaxBufferedDocs(configuration.getInteractiveMaxBufferedDocs());
        }
    }

    @Override
    public void truncateIndex() throws LuceneException {
        this.withWriter(new ILuceneConnection.WriterAction(){

            @Override
            public void perform(IndexWriter writer) throws IOException {
                writer.deleteAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureIndexExists(Directory directory) throws IOException {
        this.indexWriteLock.lock();
        try {
            if (!DirectoryReader.indexExists((Directory)directory)) {
                new IndexWriter(directory, new IndexWriterConfig(BonnieConstants.LUCENE_VERSION, null)).close();
            }
        }
        finally {
            this.indexWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCorrectIndexFormat(Directory directory) throws IOException {
        if (!(directory instanceof FSDirectory)) {
            log.info("Expect FSDirectory. Skip index format check");
            return;
        }
        this.indexWriteLock.lock();
        try {
            LuceneConnection.upgradeIndexIfNecessary(((FSDirectory)directory).getDirectory(), directory);
        }
        finally {
            this.indexWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLockOnDirectory(Directory directory) throws IOException {
        this.indexWriteLock.lock();
        try {
            if (IndexWriter.isLocked((Directory)directory)) {
                log.warn("Forcing unlock of locked index directory: " + directory);
                IndexWriter.unlock((Directory)directory);
            }
        }
        finally {
            this.indexWriteLock.unlock();
        }
    }

    private static void upgradeIndexIfNecessary(File directoryPath, Directory directory) throws IOException {
        try {
            new IndexWriter(directory, new IndexWriterConfig(BonnieConstants.LUCENE_VERSION, null)).close();
        }
        catch (IndexFormatTooOldException e) {
            log.info("Detected old index format. Attempting an upgrade.");
            LuceneConnection.upgradeIndexToLucene36(directoryPath);
            LuceneConnection.upgradeIndexToCurrentLuceneVersion(directory);
        }
    }

    private static void upgradeIndexToCurrentLuceneVersion(Directory directory) throws IOException {
        log.info("Upgrading index to " + BonnieConstants.LUCENE_VERSION.name());
        IndexUpgrader indexUpgrader = new IndexUpgrader(directory, BonnieConstants.LUCENE_VERSION);
        indexUpgrader.upgrade();
        log.info("Index upgraded to " + BonnieConstants.LUCENE_VERSION.name());
    }

    private static void upgradeIndexToLucene36(File directory) throws IOException {
        log.info("Upgrading index to Lucene 3.6");
        LuceneIndexUpgrader indexUpgrader = LuceneIndexUpgrader.create((File)directory);
        indexUpgrader.upgrade();
        log.info("Index upgraded to Lucene 3.6");
    }
}

