/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneException;
import com.atlassian.bonnie.index.BaseMultiThreadedIndexer;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.ObjectToDocumentConverter;
import com.atlassian.bonnie.index.QueueProcessingRunnableImpl;
import com.atlassian.bonnie.index.SingleDocumentWritingScheme;
import com.atlassian.bonnie.index.SingleObjectIndexer;
import com.atlassian.bonnie.index.SingletonObjectQueue;
import com.atlassian.bonnie.index.TempDirectoryDocumentWritingScheme;
import com.atlassian.core.util.ProgressWrapper;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineMultiThreadedIndexer
extends BaseMultiThreadedIndexer
implements SingleObjectIndexer {
    private static final Logger log = LoggerFactory.getLogger(OnlineMultiThreadedIndexer.class);
    protected BlockingQueue<? super Object> reindexAddedQueue = new LinkedBlockingQueue<Object>();
    protected BlockingQueue<? super Object> reindexDeletedQueue = new LinkedBlockingQueue<Object>();
    private ObjectToDocumentConverter objectToDocumentConverter;

    @Override
    protected void allThreadsComplete(final BatchOpIndexer.DocumentWritingScheme scheme, final boolean truncate, final ProgressWrapper progress) {
        this.luceneConnection.withBatchUpdate(new ILuceneConnection.BatchUpdateAction(){

            @Override
            public void perform() throws Exception {
                OnlineMultiThreadedIndexer.this.setReindexingStatus(true);
                if (truncate) {
                    progress.setStatus("Truncating index");
                    OnlineMultiThreadedIndexer.this.truncateIndex();
                }
                progress.setStatus("Closing index");
                scheme.close(OnlineMultiThreadedIndexer.this.luceneConnection);
                progress.setStatus("Flushing queues");
                if (OnlineMultiThreadedIndexer.this.flushReindexingQueues()) {
                    progress.setStatus("Optimizing index");
                    OnlineMultiThreadedIndexer.this.optimize(OnlineMultiThreadedIndexer.this.luceneConnection);
                }
                OnlineMultiThreadedIndexer.this.setReindexingStatus(false);
            }
        });
    }

    @Override
    public void index(final Object o) {
        this.luceneConnection.withBatchUpdate(new ILuceneConnection.BatchUpdateAction(){

            @Override
            public void perform() {
                if (OnlineMultiThreadedIndexer.this.isReindexing()) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Adding object:" + o + " to reindexaddedqueue");
                        }
                        OnlineMultiThreadedIndexer.this.reindexAddedQueue.put(o);
                    }
                    catch (InterruptedException e) {
                        log.error("Error encountered adding object to reindexaddedqueue", (Throwable)e);
                    }
                }
                OnlineMultiThreadedIndexer.this.unindex(o);
                BatchOpIndexer.DocumentWritingScheme scheme = OnlineMultiThreadedIndexer.this.getDocumentWritingScheme(false);
                QueueProcessingRunnableImpl r = new QueueProcessingRunnableImpl(new SingletonObjectQueue(o, OnlineMultiThreadedIndexer.this.objectToDocumentConverter), scheme);
                r.run();
            }
        });
    }

    protected void doAdd(Object o, IndexWriter writer) throws IOException {
        writer.addDocument((Iterable)this.objectToDocumentConverter.convert(o, null));
    }

    @Override
    public void unindex(final Object o) {
        this.luceneConnection.withBatchUpdate(new ILuceneConnection.BatchUpdateAction(){

            @Override
            public void perform() {
                if (OnlineMultiThreadedIndexer.this.isReindexing()) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Adding object:" + o + " to reindexdeletedqueue");
                        }
                        OnlineMultiThreadedIndexer.this.reindexDeletedQueue.put(o);
                    }
                    catch (InterruptedException e) {
                        log.error("Error encountered adding object to reindexdeletedqueue", (Throwable)e);
                    }
                }
                OnlineMultiThreadedIndexer.this.luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

                    @Override
                    public void perform(IndexWriter writer) throws IOException {
                        OnlineMultiThreadedIndexer.this.doDelete(o, writer);
                    }
                });
            }
        });
    }

    protected void doDelete(Object o, IndexWriter writer) throws IOException {
        String[] identity = this.objectToDocumentConverter.getObjectIdentity(o);
        writer.deleteDocuments(new Term(identity[0], identity[1]));
    }

    protected final void optimize(ILuceneConnection conn) {
        conn.withWriter(new ILuceneConnection.WriterAction(){

            @Override
            public void perform(IndexWriter writer) throws IOException {
                writer.forceMerge(1);
            }
        });
    }

    private boolean flushReindexingQueues() {
        boolean somethingflushed = false;
        if (!this.reindexDeletedQueue.isEmpty()) {
            this.luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

                @Override
                public void perform(IndexWriter writer) throws IOException {
                    try {
                        Object o = OnlineMultiThreadedIndexer.this.reindexDeletedQueue.take();
                        while (!OnlineMultiThreadedIndexer.this.reindexDeletedQueue.isEmpty()) {
                            OnlineMultiThreadedIndexer.this.doDelete(o, writer);
                            o = OnlineMultiThreadedIndexer.this.reindexDeletedQueue.take();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new LuceneException(e);
                    }
                }
            });
            somethingflushed = true;
        }
        if (!this.reindexAddedQueue.isEmpty()) {
            this.luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

                @Override
                public void perform(IndexWriter writer) throws IOException {
                    try {
                        Object o = OnlineMultiThreadedIndexer.this.reindexAddedQueue.take();
                        while (!OnlineMultiThreadedIndexer.this.reindexAddedQueue.isEmpty()) {
                            OnlineMultiThreadedIndexer.this.doAdd(o, writer);
                            o = OnlineMultiThreadedIndexer.this.reindexAddedQueue.take();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new LuceneException(e);
                    }
                }
            });
            somethingflushed = true;
        }
        return somethingflushed;
    }

    protected BatchOpIndexer.DocumentWritingScheme getDocumentWritingScheme(boolean reindex) {
        if (reindex) {
            return new TempDirectoryDocumentWritingScheme(this);
        }
        return new SingleDocumentWritingScheme(this.luceneConnection);
    }

    @Override
    public void setLuceneConnection(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    protected ObjectToDocumentConverter getObjectToDocumentConverter() {
        return this.objectToDocumentConverter;
    }

    @Override
    public void setObjectToDocumentConverter(ObjectToDocumentConverter objectToDocumentConverter) {
        this.objectToDocumentConverter = objectToDocumentConverter;
    }

    @Override
    public Analyzer getAnalyzer() {
        return new StandardAnalyzer(BonnieConstants.LUCENE_VERSION);
    }

    protected void setReindexingStatus(boolean status) throws IOException {
        this.setReindexing(status);
    }
}

