/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import com.atlassian.bonnie.Handle;
import com.atlassian.bonnie.HandleResolver;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.DocumentBuilder;
import com.atlassian.bonnie.search.DocumentPostProcessor;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.HibernateUnwrapper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDocumentBuilder
implements DocumentBuilder {
    private static final Logger log = LoggerFactory.getLogger(BaseDocumentBuilder.class);
    private final HandleResolver handleResolver;
    private final List<Extractor> extractors;
    private final List<DocumentPostProcessor> postProcessors;
    public static final String TYPE_FIELD = "type";
    public static final String URL_PATH_FIELD = "urlPath";
    private static final int CONTENT_BODY_MAX_SIZE = new ContentBodyMaxSizeSystemProperty().getValue();

    public BaseDocumentBuilder(HandleResolver handleResolver, List<Extractor> extractors, List<DocumentPostProcessor> postProcessors) {
        if (extractors == null) {
            throw new IllegalArgumentException("extractors is required.");
        }
        if (postProcessors == null) {
            throw new IllegalArgumentException("postProcessors is required.");
        }
        if (handleResolver == null) {
            throw new IllegalArgumentException("handleResolver is required.");
        }
        this.handleResolver = handleResolver;
        this.extractors = Collections.unmodifiableList(new ArrayList<Extractor>(extractors));
        this.postProcessors = Collections.unmodifiableList(new ArrayList<DocumentPostProcessor>(postProcessors));
    }

    @Override
    public Document getDocument(Searchable searchable) {
        Document document = this.getInitialDocument(searchable);
        StringBuffer contentBody = new StringBuffer();
        for (Extractor extractor : this.extractors) {
            try {
                extractor.addFields(document, contentBody, searchable);
            }
            catch (RuntimeException e) {
                log.error("Error extracting search fields from " + searchable + " using " + extractor + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (contentBody.length() > 0) {
            Field.Store store = contentBody.length() > CONTENT_BODY_MAX_SIZE ? Field.Store.NO : Field.Store.YES;
            document.add((IndexableField)new Field("contentBody", contentBody.toString(), store, Field.Index.ANALYZED));
        }
        for (DocumentPostProcessor documentPostProcessor : this.postProcessors) {
            documentPostProcessor.process(document);
        }
        return document;
    }

    protected Document getInitialDocument(Searchable searchable) {
        Object urlPath;
        Document document = new Document();
        Field handleField = new Field("handle", ((Object)this.getHandle(searchable)).toString(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        document.add((IndexableField)handleField);
        Field classNameField = new Field("classname", HibernateUnwrapper.getUnderlyingClass(searchable).getName(), Field.Store.NO, Field.Index.NOT_ANALYZED);
        document.add((IndexableField)classNameField);
        Object type = this.getProperty(searchable, TYPE_FIELD);
        if (type != null) {
            document.add((IndexableField)new Field(TYPE_FIELD, type.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if ((urlPath = this.getProperty(searchable, URL_PATH_FIELD)) != null) {
            document.add((IndexableField)new Field(URL_PATH_FIELD, urlPath.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return document;
    }

    private Object getProperty(Object object, String field) {
        try {
            return PropertyUtils.getProperty((Object)object, (String)field);
        }
        catch (NoSuchMethodException e) {
            log.info("Unable to find field '" + field + "' on " + object, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.info("Unable to access field '" + field + "' on " + object, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.info("Problem accessing field '" + field + "' on " + object, (Throwable)e);
        }
        return null;
    }

    @Override
    public Handle getHandle(Object obj) {
        return this.handleResolver.getHandle(obj);
    }

    public static class FieldName {
        public static final String HANDLE = "handle";
        public static final String CLASS_NAME = "classname";
        public static final String CONTENT_BODY = "contentBody";
    }

    static class ContentBodyMaxSizeSystemProperty {
        public static final int DEFAULT = 0x100000;
        private final int value;

        public ContentBodyMaxSizeSystemProperty() {
            int value;
            String contentBodyMaxSize = System.getProperty("atlassian.indexing.contentbody.maxsize");
            if (contentBodyMaxSize != null) {
                try {
                    value = Integer.parseInt(contentBodyMaxSize);
                }
                catch (NumberFormatException e) {
                    value = 0x100000;
                }
            } else {
                value = 0x100000;
            }
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

