/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import java.io.IOException;
import java.util.WeakHashMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;

public class InvertedQueryFilter
extends Filter {
    private Query query;
    private transient WeakHashMap cache = null;

    public InvertedQueryFilter(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        AtomicReader reader = context.reader();
        if (this.cache == null) {
            this.cache = new WeakHashMap();
        }
        WeakHashMap weakHashMap = this.cache;
        synchronized (weakHashMap) {
            DocIdSet cached = (DocIdSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        final OpenBitSet bits = new OpenBitSet((long)reader.maxDoc());
        new IndexSearcher((IndexReader)reader).search(this.query, new Collector(){
            private int docBase;

            public void setScorer(Scorer scorer) throws IOException {
            }

            public void collect(int doc) throws IOException {
                bits.fastSet(doc + this.docBase);
            }

            public void setNextReader(AtomicReaderContext atomicReaderContext) throws IOException {
                this.docBase = atomicReaderContext.docBase;
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }
        });
        bits.flip(0L, (long)reader.maxDoc());
        WeakHashMap weakHashMap2 = this.cache;
        synchronized (weakHashMap2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }

    public String toString() {
        return "InvertedQueryFilter(" + this.query + ")";
    }
}

