/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.Indexer;
import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.DocumentBuilder;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LuceneIndexer
implements Indexer {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexer.class);
    private ILuceneConnection luceneConnection;
    private DocumentBuilder documentBuilder;

    @Override
    public void index(final Searchable obj) {
        if (!obj.isIndexable()) {
            return;
        }
        this.unIndex(obj);
        this.luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(IndexWriter indexWriter) throws IOException {
                try {
                    MDC.put((String)"Indexing", (String)obj.toString());
                    indexWriter.addDocument((Iterable)LuceneIndexer.this.documentBuilder.getDocument(obj));
                }
                finally {
                    MDC.remove((String)"Indexing");
                }
            }
        });
    }

    @Override
    public void unIndex(final Searchable obj) {
        this.luceneConnection.withWriter(new ILuceneConnection.WriterAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(IndexWriter writer) throws IOException {
                try {
                    MDC.put((String)"Unindexing", (String)obj.toString());
                    Term t = new Term("handle", ((Object)LuceneIndexer.this.documentBuilder.getHandle(obj)).toString());
                    writer.deleteDocuments(t);
                }
                finally {
                    MDC.remove((String)"Unindexing");
                }
            }
        });
    }

    @Override
    public void reIndex(Searchable obj) {
        this.unIndex(obj);
        this.index(obj);
    }

    public void unIndexAll() {
        this.luceneConnection.truncateIndex();
    }

    public void setLuceneConnection(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }
}

