/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneException;
import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.bonnie.Searcher;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.bonnie.search.FilterCountingSearcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSearcher
implements Searcher {
    private static final Logger log = LoggerFactory.getLogger(LuceneSearcher.class);
    private ILuceneConnection luceneConnection;
    private LuceneAnalyzerFactory luceneAnalyzerFactory;
    private static final String[] HANDLE_ONLY_FIELDS = new String[]{"handle"};

    public void setLuceneConnection(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    public void setLuceneAnalyzerFactory(LuceneAnalyzerFactory luceneAnalyzerFactory) {
        this.luceneAnalyzerFactory = luceneAnalyzerFactory;
    }

    public void setBooleanQueryMaxClause(int max) {
        BooleanQuery.setMaxClauseCount((int)max);
    }

    @Override
    public Query buildStandardQuery(String[] searchFields, String query) {
        Query myquery;
        try {
            QueryParser qp = this.makeQueryParserForSearchFields(searchFields);
            qp.setDefaultOperator(QueryParser.Operator.AND);
            myquery = qp.parse(query);
        }
        catch (ParseException e) {
            throw new LuceneException("Couldn't parse the query successfully:" + e.getMessage());
        }
        return myquery;
    }

    private QueryParser makeQueryParserForSearchFields(String[] searchFields) {
        if (searchFields.length == 1) {
            return new QueryParser(BonnieConstants.LUCENE_VERSION, searchFields[0], this.luceneAnalyzerFactory.createAnalyzer());
        }
        return new MultiFieldQueryParser(BonnieConstants.LUCENE_VERSION, searchFields, this.luceneAnalyzerFactory.createAnalyzer());
    }

    @Override
    public Query buildStandardQuery(String defaultSearchField, String query) {
        return this.buildStandardQuery(new String[]{defaultSearchField}, query);
    }

    @Override
    public List search(final Query myquery) {
        final LinkedList result = new LinkedList();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            @Override
            public void perform(IndexSearcher searcher) throws IOException {
                TopDocs hits = searcher.search(myquery, searcher.getIndexReader().maxDoc());
                int x = hits.scoreDocs.length;
                for (int i = 0; i < x; ++i) {
                    Document doc = searcher.doc(hits.scoreDocs[i].doc);
                    String handle = doc.get("handle");
                    result.add(handle);
                }
            }
        });
        return result;
    }

    @Override
    public List search(final Query myquery, final Sort sort) {
        final LinkedList result = new LinkedList();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            @Override
            public void perform(IndexSearcher searcher) throws IOException {
                TopFieldDocs hits = searcher.search(myquery, searcher.getIndexReader().maxDoc(), sort);
                int x = hits.scoreDocs.length;
                for (int i = 0; i < x; ++i) {
                    Document doc = searcher.doc(hits.scoreDocs[i].doc);
                    String handle = doc.get("handle");
                    result.add(handle);
                }
            }
        });
        return result;
    }

    @Override
    public Query rewrite(final Query query) {
        return (Query)this.luceneConnection.withReader(new ILuceneConnection.ReaderAction(){

            @Override
            public Object perform(IndexReader reader) throws IOException {
                return query.rewrite(reader);
            }
        });
    }

    @Override
    public String explain(final Query myquery, final int docid) {
        final StringBuffer sb = new StringBuffer();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            @Override
            public void perform(IndexSearcher searcher) throws IOException {
                Explanation e = searcher.explain(myquery, docid);
                sb.append(e.toHtml());
            }
        });
        return sb.toString();
    }

    @Override
    public int searchCount(Query query) {
        return this.searchCount(query, null);
    }

    @Override
    public int searchCount(final Query query, final Filter filter) {
        final TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            @Override
            public void perform(IndexSearcher searcher) throws IOException {
                searcher.search(query, filter, (Collector)totalHitCountCollector);
            }
        });
        return totalHitCountCollector.getTotalHits();
    }

    @Override
    public List searchForFields(Query myquery, Set fieldsToExtract, int startIndex, int numItems) {
        return this.searchForFields(myquery, fieldsToExtract, startIndex, numItems, null, new int[1]);
    }

    @Override
    public List searchForFields(Query myquery, Set fieldsToExtract, int startIndex, int numItems, Filter filter, int[] filteredcount) {
        return this.searchForFields(myquery, fieldsToExtract, startIndex, numItems, null, null, new int[1]);
    }

    @Override
    public List searchForFields(final Query myquery, Set fieldsToExtract, final int startIndex, final int numItems, final Filter filter, final Sort sort, final int[] filteredcount) {
        String[] fieldsToExtractArr = fieldsToExtract != null && fieldsToExtract.size() > 0 ? fieldsToExtract.toArray(new String[fieldsToExtract.size()]) : HANDLE_ONLY_FIELDS;
        final String[] fieldsToExtractArr1 = fieldsToExtractArr;
        final ArrayList results = new ArrayList();
        this.luceneConnection.withSearch(new ILuceneConnection.SearcherAction(){

            @Override
            public void perform(IndexSearcher searcher) throws IOException {
                Object hits = sort == null ? searcher.search(myquery, filter, searcher.getIndexReader().maxDoc()) : searcher.search(myquery, filter, searcher.getIndexReader().maxDoc(), sort);
                if (searcher instanceof FilterCountingSearcher) {
                    FilterCountingSearcher filterCountingSearcher = (FilterCountingSearcher)searcher;
                    for (int i = 0; i < filterCountingSearcher.getFilteredCounts().length; ++i) {
                        if (i > filteredcount.length - 1) {
                            log.error("Array passed in to store filter counts is too small. Actual: " + filteredcount.length + ". Expected: " + filterCountingSearcher.getFilteredCounts().length);
                            break;
                        }
                        filteredcount[i] = filterCountingSearcher.getFilteredCounts()[i];
                    }
                }
                results.ensureCapacity(startIndex + numItems);
                int x = hits.totalHits;
                for (int i = 0; i < x; ++i) {
                    HashMap<String, Integer> result;
                    if (i < startIndex || i >= startIndex + numItems) {
                        results.add(null);
                        continue;
                    }
                    int docId = hits.scoreDocs[i].doc;
                    Document doc = searcher.doc(docId);
                    if (fieldsToExtractArr1 == null) {
                        result = LuceneUtils.buildMapFromDocument(doc);
                    } else {
                        result = new HashMap<String, Integer>(fieldsToExtractArr1.length);
                        for (int j = 0; j < fieldsToExtractArr1.length; ++j) {
                            String fieldname = fieldsToExtractArr1[j];
                            result.put(fieldname, (Integer)((Object)doc.get(fieldname)));
                        }
                    }
                    result.put("docid", docId);
                    results.add(result);
                }
            }
        });
        return results;
    }

    @Override
    public List getAllFieldValues(final String fieldName) {
        return (List)this.luceneConnection.withReader(new ILuceneConnection.ReaderAction(){

            @Override
            public Object perform(IndexReader reader) throws IOException {
                ArrayList<String> values = new ArrayList<String>();
                Terms terms = MultiFields.getTerms((IndexReader)reader, (String)fieldName);
                if (terms != null) {
                    TermsEnum termsEnum = terms.iterator(null);
                    while (termsEnum.next() != null) {
                        values.add(termsEnum.term().utf8ToString());
                    }
                }
                return values;
            }
        });
    }
}

