/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTextContentExtractor
extends BaseAttachmentContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(DefaultTextContentExtractor.class);

    @Override
    protected boolean shouldExtractFrom(String fileName, String contentType) {
        return contentType.startsWith("text/") || contentType.startsWith("application/xml") || contentType.startsWith("application/") && contentType.endsWith("+xml");
    }

    @Override
    protected String extractText(InputStream is, SearchableAttachment attachment) {
        try {
            return IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("Couldn't extract text from attachment: " + attachment, (Throwable)e);
            return null;
        }
    }
}

