/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.extractor;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.bonnie.search.extractor.util.AbstractLengthLimitedStringBuilder;
import com.atlassian.bonnie.search.extractor.util.LimitReachedException;
import com.atlassian.bonnie.search.extractor.util.StaticLengthLimitedStringBuilder;
import com.atlassian.bonnie.search.extractor.util.StringBuilderWriter;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfContentExtractor
extends BaseAttachmentContentExtractor {
    private static final Logger log = LoggerFactory.getLogger(PdfContentExtractor.class);
    private static final String[] EXTENSIONS = new String[]{"pdf"};
    private static final String[] CONTENT_TYPES = new String[]{"application/pdf"};
    private static final int DEFAULT_MAX_RESULT_SIZE = 0x800000;
    private final int maxResultSize;

    public PdfContentExtractor() {
        this(0x800000);
    }

    public PdfContentExtractor(int maxResultSize) {
        this.maxResultSize = maxResultSize;
    }

    @Override
    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    @Override
    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        File scratchFile = null;
        PDDocument pdfDocument = null;
        try {
            scratchFile = File.createTempFile(this.getClass().getSimpleName() + "-", ".scratch");
            pdfDocument = PDDocument.load((InputStream)is, (RandomAccess)new RandomAccessFile(scratchFile, "rw"));
            if (pdfDocument.isEncrypted()) {
                pdfDocument.decrypt("");
            }
            PDFTextStripper stripper = new PDFTextStripper();
            StringBuilderWriter writer = new StringBuilderWriter(new StaticLengthLimitedStringBuilder(this.maxResultSize / 2, AbstractLengthLimitedStringBuilder.LIMIT_BEHAVIOUR.THROW));
            try {
                stripper.writeText(pdfDocument, (Writer)writer);
            }
            catch (LimitReachedException e) {
                log.debug("Reached maximum result length of {} bytes", (Object)this.maxResultSize);
            }
            finally {
                writer.close();
            }
            String string = writer.toString();
            return string;
        }
        catch (CryptographyException e) {
            throw new ExtractorException("Could not decrypt PDF document: " + e.getMessage(), e);
        }
        catch (InvalidPasswordException e) {
            throw new ExtractorException("Password required for encrypted PDF document", e);
        }
        catch (Exception e) {
            throw new ExtractorException("Error getting content of PDF document", e);
        }
        finally {
            if (pdfDocument != null) {
                try {
                    pdfDocument.close();
                }
                catch (Exception e) {}
            }
            if (scratchFile != null) {
                try {
                    if (!scratchFile.delete()) {
                        scratchFile.deleteOnExit();
                    }
                }
                catch (Exception e) {}
            }
        }
    }
}

