/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.search.summary;

import com.atlassian.bonnie.BonnieConstants;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.analyzer.LuceneAnalyzerFactory;
import com.atlassian.bonnie.search.summary.Excerpt;
import com.atlassian.bonnie.search.summary.Summary;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Summarizer {
    private static final Logger log = LoggerFactory.getLogger(Summarizer.class);
    private static final int DEFAULT_SUM_CONTEXT = 10;
    private static final int DEFAULT_SUM_LENGTH = 30;
    private Analyzer analyzer;
    private StandardAnalyzer standardAnalyzer = new StandardAnalyzer(BonnieConstants.LUCENE_VERSION);
    private int sumContext = 10;
    private int sumLength = 30;
    private ILuceneConnection luceneConnection;

    public Summarizer() {
    }

    public Summarizer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Summarizer(Analyzer analyzer, int sumContext, int sumLength, ILuceneConnection luceneConnection) {
        this.analyzer = analyzer;
        this.sumContext = sumContext;
        this.sumLength = sumLength;
        this.luceneConnection = luceneConnection;
    }

    public Summary getSummary(String text) throws IOException {
        return this.getSummary(text, null);
    }

    public Summary getSummary(String text, String query) throws IOException {
        log.debug("\n\ntext = " + text);
        log.debug("query = " + query);
        Attributes[] tokens = this.parseText(text);
        if (log.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < tokens.length; ++i) {
                buf.append(tokens[i].getText());
                if (i == tokens.length - 1) continue;
                buf.append(", ");
            }
            log.debug("tokens = ");
        }
        if (tokens.length == 0) {
            return new Summary();
        }
        Set highlight = this.getTerms(query);
        log.debug("highlight = " + highlight);
        TreeSet<Excerpt> excerptSet = new TreeSet<Excerpt>(new Comparator(){

            public int compare(Object o1, Object o2) {
                int numToks2;
                Excerpt excerpt1 = (Excerpt)o1;
                Excerpt excerpt2 = (Excerpt)o2;
                if (excerpt1 == null && excerpt2 != null) {
                    return -1;
                }
                if (excerpt1 != null && excerpt2 == null) {
                    return 1;
                }
                if (excerpt1 == null && excerpt2 == null) {
                    return 0;
                }
                int numToks1 = excerpt1.numUniqueTokens();
                if (numToks1 < (numToks2 = excerpt2.numUniqueTokens())) {
                    return -1;
                }
                if (numToks1 == numToks2) {
                    return excerpt1.numFragments() - excerpt2.numFragments();
                }
                return 1;
            }
        });
        int lastExcerptPos = 0;
        if (highlight.size() > 0) {
            for (int i = 0; i < tokens.length; ++i) {
                if (!highlight.contains(tokens[i].getText())) continue;
                int startToken = i > this.sumContext ? i - this.sumContext : 0;
                int endToken = Math.min(i + this.sumContext, tokens.length);
                int startOffset = tokens[startToken].getStartOffset();
                int currentToken = startToken;
                Excerpt excerpt = new Excerpt();
                if (startOffset != 0) {
                    excerpt.add(new Summary.Ellipsis());
                }
                while (currentToken < endToken && currentToken - startToken < this.sumLength) {
                    Attributes t = tokens[currentToken];
                    if (highlight.contains(t.getText())) {
                        excerpt.addToken(t.getText());
                        excerpt.add(new Summary.Fragment(text.substring(startOffset, t.getStartOffset())));
                        excerpt.add(new Summary.Highlight(text.substring(t.getStartOffset(), t.getEndOffset())));
                        startOffset = t.getEndOffset();
                        endToken = Math.min(currentToken + this.sumContext, tokens.length);
                    }
                    ++currentToken;
                }
                lastExcerptPos = endToken;
                if (currentToken < tokens.length) {
                    excerpt.add(new Summary.Fragment(text.substring(startOffset, tokens[currentToken].getEndOffset())));
                } else {
                    int endOffset = tokens[tokens.length - 1].getEndOffset();
                    String trailingFragment = text.substring(startOffset, endOffset);
                    if (!StringUtils.isEmpty((String)trailingFragment)) {
                        excerpt.add(new Summary.Fragment(trailingFragment));
                    }
                }
                excerpt.setNumTerms(currentToken - startToken);
                excerptSet.add(excerpt);
                i = currentToken + this.sumContext;
            }
        }
        if (excerptSet.size() == 0) {
            int excerptLen;
            Excerpt excerpt = new Excerpt();
            lastExcerptPos = excerptLen = Math.min(this.sumLength, tokens.length);
            excerpt.add(new Summary.Fragment(text.substring(tokens[0].getStartOffset(), tokens[excerptLen - 1].getEndOffset())));
            excerpt.setNumTerms(excerptLen);
            excerptSet.add(excerpt);
        }
        log.debug("Found excerpts = " + excerptSet.size());
        double tokenCount = 0.0;
        Summary s = new Summary();
        while (tokenCount <= (double)this.sumLength && excerptSet.size() > 0) {
            Excerpt excerpt = (Excerpt)excerptSet.last();
            excerptSet.remove(excerpt);
            double tokenFraction = 1.0 * (double)excerpt.getNumTerms() / (double)excerpt.numFragments();
            Enumeration e = excerpt.elements();
            while (e.hasMoreElements()) {
                Summary.Fragment f = (Summary.Fragment)e.nextElement();
                if (tokenCount + tokenFraction <= (double)this.sumLength) {
                    s.add(f);
                }
                tokenCount += tokenFraction;
            }
        }
        if (tokenCount > 0.0 && lastExcerptPos < tokens.length) {
            s.add(new Summary.Ellipsis());
        }
        return s;
    }

    private Set getTerms(final String query) {
        if (StringUtils.isNotEmpty((String)query)) {
            try {
                HashSet<String> tokens = new HashSet<String>();
                if (this.luceneConnection != null && query.indexOf(42) > -1) {
                    QueryParser qp = new QueryParser(BonnieConstants.LUCENE_VERSION, "contentBody", this.analyzer);
                    try {
                        Query parsed = qp.parse(query);
                        String[] queryTemp = new String[1];
                        Set set = (Set)this.luceneConnection.withReader(new ILuceneConnection.ReaderAction(){

                            @Override
                            public Object perform(IndexReader reader) throws IOException {
                                String transformedQuery = query.replaceAll("\\.", "\\.");
                                transformedQuery = transformedQuery.replaceAll("\\*", ".*");
                                transformedQuery = transformedQuery.replaceAll("\\?", ".");
                                HashSet<String> set = new HashSet<String>();
                                Fields fields = MultiFields.getFields((IndexReader)reader);
                                if (fields != null) {
                                    for (String field : fields) {
                                        BytesRef text;
                                        Terms terms = fields.terms(field);
                                        if (terms == null) continue;
                                        TermsEnum termEnum = terms.iterator(null);
                                        String[] tokens = transformedQuery.split(" ");
                                        while ((text = termEnum.next()) != null) {
                                            String termString = text.utf8ToString();
                                            for (int i = 0; i < tokens.length; ++i) {
                                                if (!Pattern.matches(tokens[i], termString)) continue;
                                                set.add(termString);
                                            }
                                        }
                                    }
                                }
                                return set;
                            }
                        });
                        tokens.addAll(set);
                    }
                    catch (ParseException e) {
                        log.warn("Error encountered parsing query: " + query + " for wildcard match.", (Throwable)e);
                    }
                }
                TokenStream ts = this.analyzer.tokenStream("contentBody", (Reader)new StringReader(query));
                ts.reset();
                CharTermAttribute charTermAttribute = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
                while (ts.incrementToken()) {
                    tokens.add(charTermAttribute.toString());
                }
                ts.end();
                ts.close();
                return tokens;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes[] parseText(String text) throws IOException {
        if (text == null || text.trim().equals("")) {
            return new Attributes[0];
        }
        LinkedList<Attributes> result = new LinkedList<Attributes>();
        TokenStream ts = this.analyzer.tokenStream("contentBody", (Reader)new StringReader(text));
        OffsetAttribute offsetAttribute = (OffsetAttribute)ts.addAttribute(OffsetAttribute.class);
        CharTermAttribute charTermAttribute = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        try {
            ts.reset();
            while (ts.incrementToken()) {
                result.add(new Attributes(charTermAttribute.toString(), offsetAttribute.startOffset(), offsetAttribute.endOffset()));
            }
            ts.end();
        }
        finally {
            ts.close();
        }
        return result.toArray(new Attributes[result.size()]);
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public void setSumContext(int sumContext) {
        this.sumContext = sumContext;
    }

    public void setSumLength(int sumLength) {
        this.sumLength = sumLength;
    }

    public void setAnalyzerFactory(LuceneAnalyzerFactory f) {
        this.analyzer = f.createAnalyzer();
    }

    public void setLuceneConnection(ILuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    private static class Attributes {
        private final String text;
        private final int startOffset;
        private final int endOffset;

        private Attributes(String text, int startOffset, int endOffset) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public String getText() {
            return this.text;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

