package com.atlassian.bonnie;

import java.util.concurrent.TimeUnit;

/**
 * Configuration for an {@link ILuceneConnection}, with the default values as used by Confluence.
 */
public class DefaultConfiguration implements ILuceneConnection.Configuration
{
    private int batchMaxBufferedDocs = 300;
    private int batchMaxMergeDocs = Integer.MAX_VALUE;
    private int batchMergeFactor = 50;
    private int interactiveMaxBufferedDocs = 300;
    private int interactiveMaxMergeDocs = 5000;
    private int interactiveMergeFactor = 4;
    private long indexSearcherMaxAge = TimeUnit.MINUTES.toSeconds(2);
    private long indexSearcherPruneDelay = TimeUnit.MINUTES.toSeconds(1);

    /**
     * 1 million (the lucene default is 10,000).
     * at (say) 10 chars per token, that is a 10 meg limit. Fair enough.
     * [from Kelvin Tan]
     */
    private int maxFieldLength = 1000000;
    private boolean compoundIndexFileFormat = true;

    public int getBatchMaxBufferedDocs()
    {
        return batchMaxBufferedDocs;
    }

    public int getBatchMaxMergeDocs()
    {
        return batchMaxMergeDocs;
    }

    public int getBatchMergeFactor()
    {
        return batchMergeFactor;
    }

    public int getInteractiveMaxBufferedDocs()
    {
        return interactiveMaxBufferedDocs;
    }

    public int getInteractiveMaxMergeDocs()
    {
        return interactiveMaxMergeDocs;
    }

    public int getInteractiveMergeFactor()
    {
        return interactiveMergeFactor;
    }

    public int getMaxFieldLength()
    {
        return maxFieldLength;
    }

    public boolean isCompoundIndexFileFormat()
    {
        return compoundIndexFileFormat;
    }

    public long getIndexSearcherMaxAge()
    {
        return indexSearcherMaxAge;
    }

    public long getIndexSearcherPruneDelay()
    {
        return indexSearcherPruneDelay;
    }

    public void setBatchMaxBufferedDocs(int batchMaxBufferedDocs)
    {
        this.batchMaxBufferedDocs = batchMaxBufferedDocs;
    }

    public void setBatchMaxMergeDocs(int batchMaxMergeDocs)
    {
        this.batchMaxMergeDocs = batchMaxMergeDocs;
    }

    public void setBatchMergeFactor(int batchMergeFactor)
    {
        this.batchMergeFactor = batchMergeFactor;
    }

    public void setInteractiveMaxBufferedDocs(int interactiveMaxBufferedDocs)
    {
        this.interactiveMaxBufferedDocs = interactiveMaxBufferedDocs;
    }

    public void setInteractiveMaxMergeDocs(int interactiveMaxMergeDocs)
    {
        this.interactiveMaxMergeDocs = interactiveMaxMergeDocs;
    }

    public void setInteractiveMergeFactor(int interactiveMergeFactor)
    {
        this.interactiveMergeFactor = interactiveMergeFactor;
    }

    public void setMaxFieldLength(int maxFieldLength)
    {
        this.maxFieldLength = maxFieldLength;
    }

    public void setCompoundIndexFileFormat(boolean compoundIndexFileFormat)
    {
        this.compoundIndexFileFormat = compoundIndexFileFormat;
    }

    public void setIndexSearcherMaxAge(long indexSearcherMaxAge)
    {
        this.indexSearcherMaxAge = indexSearcherMaxAge;
    }

    public void setIndexSearcherPruneDelay(long indexSearcherPruneDelay)
    {
        this.indexSearcherPruneDelay = indexSearcherPruneDelay;
    }
}
